/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import nablarch.common.dao.ColumnMeta;
import nablarch.common.dao.EntityMeta;
import nablarch.core.beans.BeanUtil;
import nablarch.core.beans.BeansException;
import nablarch.core.db.statement.SqlRow;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;

@Published(tag={"architect"})
public final class EntityUtil {
    private static final Map<Class<?>, EntityMeta> ENTITY_META_MAP = new WeakHashMap();

    private EntityUtil() {
    }

    public static String getTableName(Class<?> entityClass) {
        return EntityUtil.findEntityMeta(entityClass).getTableName();
    }

    public static String getSchemaName(Class<?> entityClass) {
        return EntityUtil.findEntityMeta(entityClass).getSchemaName();
    }

    public static String getTableNameWithSchema(Class<?> entityClass) {
        String tableName = EntityUtil.getTableName(entityClass);
        String schemaName = EntityUtil.getSchemaName(entityClass);
        if (StringUtil.isNullOrEmpty((String)schemaName)) {
            return tableName;
        }
        return schemaName + '.' + tableName;
    }

    public static List<ColumnMeta> findIdColumns(Class<?> entityClass) {
        return EntityUtil.findEntityMeta(entityClass).getIdColumns();
    }

    public static <T> Map<ColumnMeta, Object> findIdColumns(T entity) {
        assert (entity != null);
        LinkedHashMap<ColumnMeta, Object> idColumns = new LinkedHashMap<ColumnMeta, Object>();
        for (ColumnMeta meta : EntityUtil.findEntityMeta(entity.getClass()).getIdColumns()) {
            idColumns.put(meta, BeanUtil.getProperty(entity, (String)meta.getPropertyName(), meta.getJdbcType()));
        }
        return idColumns;
    }

    public static List<ColumnMeta> findAllColumns(Class<?> entityClass) {
        return EntityUtil.findEntityMeta(entityClass).getAllColumns();
    }

    public static <T> Map<ColumnMeta, Object> findAllColumns(T entity) {
        assert (entity != null);
        LinkedHashMap<ColumnMeta, Object> columns = new LinkedHashMap<ColumnMeta, Object>();
        for (ColumnMeta meta : EntityUtil.findEntityMeta(entity.getClass()).getAllColumns()) {
            columns.put(meta, BeanUtil.getProperty(entity, (String)meta.getPropertyName(), meta.getJdbcType()));
        }
        return columns;
    }

    public static <T> ColumnMeta findVersionColumn(T entity) {
        assert (entity != null);
        return EntityUtil.findEntityMeta(entity.getClass()).getVersionColumn();
    }

    public static <T> ColumnMeta findGeneratedValueColumn(T entity) {
        assert (entity != null);
        return EntityUtil.findGeneratedValueColumn(entity.getClass());
    }

    public static <T> ColumnMeta findGeneratedValueColumn(Class<T> entityClass) {
        return EntityUtil.findEntityMeta(entityClass).getGeneratedValueColumn();
    }

    public static <T> T createEntity(Class<T> entityClass, SqlRow row) {
        T entity;
        try {
            entity = entityClass.newInstance();
        }
        catch (Exception e) {
            throw new BeansException((Throwable)e);
        }
        EntityMeta entityMeta = EntityUtil.findEntityMeta(entityClass);
        for (ColumnMeta meta : entityMeta.getAllColumns()) {
            BigDecimal d;
            if (!row.containsKey((Object)meta.getName())) continue;
            Class<?> type = meta.getPropertyType();
            if (type.equals(String.class)) {
                BeanUtil.setProperty(entity, (String)meta.getPropertyName(), (Object)row.getString(meta.getName()));
                continue;
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                d = row.getBigDecimal(meta.getName());
                BeanUtil.setProperty(entity, (String)meta.getPropertyName(), d != null ? Short.valueOf(d.shortValue()) : null);
                continue;
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                d = row.getBigDecimal(meta.getName());
                BeanUtil.setProperty(entity, (String)meta.getPropertyName(), d != null ? Integer.valueOf(d.intValue()) : null);
                continue;
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                d = row.getBigDecimal(meta.getName());
                BeanUtil.setProperty(entity, (String)meta.getPropertyName(), d != null ? Long.valueOf(d.longValue()) : null);
                continue;
            }
            if (type.equals(BigDecimal.class)) {
                BeanUtil.setProperty(entity, (String)meta.getPropertyName(), (Object)row.getBigDecimal(meta.getName()));
                continue;
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                Boolean b = row.getBoolean(meta.getName());
                BeanUtil.setProperty(entity, (String)meta.getPropertyName(), (Object)b);
                continue;
            }
            if (type.equals(Date.class)) {
                if (meta.getJdbcType() == Timestamp.class) {
                    BeanUtil.setProperty(entity, (String)meta.getPropertyName(), (Object)row.getTimestamp(meta.getName()));
                    continue;
                }
                BeanUtil.setProperty(entity, (String)meta.getPropertyName(), (Object)row.getDate(meta.getName()));
                continue;
            }
            if (type.equals(Timestamp.class)) {
                BeanUtil.setProperty(entity, (String)meta.getPropertyName(), (Object)row.getTimestamp(meta.getName()));
                continue;
            }
            if (type.isArray() && type.getComponentType().equals(Byte.TYPE)) {
                BeanUtil.setProperty(entity, (String)meta.getPropertyName(), (Object)row.getBytes(meta.getName()));
                continue;
            }
            throw new RuntimeException("Unknown type " + type + " at " + meta.getName());
        }
        return entity;
    }

    protected static synchronized EntityMeta findEntityMeta(Class<?> entityClass) {
        EntityMeta entityMeta = ENTITY_META_MAP.get(entityClass);
        if (entityMeta == null) {
            entityMeta = new EntityMeta(entityClass);
            ENTITY_META_MAP.put(entityClass, entityMeta);
        }
        return entityMeta;
    }

    public static synchronized void clearCache() {
        ENTITY_META_MAP.clear();
    }
}

