/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import nablarch.common.dao.BatchSqlWithColumns;
import nablarch.common.dao.ColumnMeta;
import nablarch.common.dao.EntityUtil;
import nablarch.common.dao.IllegalEntityException;
import nablarch.common.dao.SqlWithParams;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;

@Published(tag={"architect"})
public class StandardSqlBuilder {
    public <T> String buildSelectByIdSql(Class<T> entityClass) {
        return this.buildSelectAllSql(entityClass) + ' ' + this.buildIdCondition(entityClass);
    }

    public <T> String buildSelectAllSql(Class<T> entityClass) {
        StringBuilder sql = new StringBuilder(512);
        sql.append("SELECT ");
        List<ColumnMeta> columns = EntityUtil.findAllColumns(entityClass);
        ArrayList<String> columnNames = new ArrayList<String>(columns.size());
        for (ColumnMeta column : columns) {
            columnNames.add(column.getName());
        }
        sql.append(StringUtil.join((String)",", columnNames));
        sql.append(" FROM ").append(EntityUtil.getTableNameWithSchema(entityClass));
        return sql.toString();
    }

    public <T> SqlWithParams buildUpdateSql(T entity) {
        BatchSqlWithColumns sqlWithColumns = this.buildBatchUpdateSql(entity.getClass());
        Map<ColumnMeta, Object> columns = EntityUtil.findAllColumns(entity);
        ArrayList<Object> params = new ArrayList<Object>();
        for (ColumnMeta column : sqlWithColumns.getColumns()) {
            params.add(columns.get(column));
        }
        return new SqlWithParams(sqlWithColumns.getSql(), params);
    }

    public <T> BatchSqlWithColumns buildBatchUpdateSql(Class<T> entityClass) {
        String tableName = this.toTableName(entityClass);
        ColumnMeta versionColumn = null;
        List<ColumnMeta> columns = EntityUtil.findAllColumns(entityClass);
        ArrayList<String> set = new ArrayList<String>();
        ArrayList<ColumnMeta> bindColumns = new ArrayList<ColumnMeta>();
        for (ColumnMeta column : columns) {
            if (column.isIdColumn()) continue;
            String columnName = column.getName();
            if (column.isVersion()) {
                set.add((String)columnName + '=' + (String)columnName + "+1");
                versionColumn = column;
                continue;
            }
            set.add((String)columnName + "=?");
            bindColumns.add(column);
        }
        List<ColumnMeta> idColumns = EntityUtil.findIdColumns(entityClass);
        ArrayList<String> where = new ArrayList<String>();
        for (ColumnMeta column : idColumns) {
            where.add(column.getName() + "=?");
            bindColumns.add(column);
        }
        if (versionColumn != null) {
            where.add(versionColumn.getName() + "=?");
            bindColumns.add(versionColumn);
        }
        StringBuilder sql = new StringBuilder(512);
        sql.append("UPDATE ").append(tableName);
        sql.append(" SET ").append(StringUtil.join((String)",", set)).append(' ').append("WHERE ").append(StringUtil.join((String)" AND ", where));
        return new BatchSqlWithColumns(sql.toString(), bindColumns);
    }

    public <T> SqlWithParams buildDeleteSql(T entity) {
        BatchSqlWithColumns sqlWithColumns = this.buildBatchDeleteSql(entity.getClass());
        Map<ColumnMeta, Object> columns = EntityUtil.findIdColumns(entity);
        ArrayList<Object> params = new ArrayList<Object>();
        for (ColumnMeta column : sqlWithColumns.getColumns()) {
            params.add(columns.get(column));
        }
        return new SqlWithParams(sqlWithColumns.getSql(), params);
    }

    public <T> BatchSqlWithColumns buildBatchDeleteSql(Class<T> entityClass) {
        StringBuilder sql = new StringBuilder(512);
        List<ColumnMeta> idColumns = EntityUtil.findIdColumns(entityClass);
        ArrayList<String> whereClause = new ArrayList<String>(idColumns.size());
        for (ColumnMeta column : idColumns) {
            whereClause.add(column.getName() + "=?");
        }
        sql.append("DELETE FROM ").append(this.toTableName(entityClass)).append(" WHERE ").append(StringUtil.join((String)" AND ", whereClause));
        return new BatchSqlWithColumns(sql.toString(), idColumns);
    }

    public <T> SqlWithParams buildInsertSql(T entity) {
        return this.buildInsertSql(entity, true);
    }

    public <T> SqlWithParams buildInsertWithIdentityColumnSql(T entity) {
        return this.buildInsertSql(entity, false);
    }

    private <T> SqlWithParams buildInsertSql(T entity, boolean includeGeneratedColumn) {
        BatchSqlWithColumns sqlWithColumns = this.buildInsertSqlWithColumns(entity.getClass(), includeGeneratedColumn);
        Map<ColumnMeta, Object> columnsWithParam = EntityUtil.findAllColumns(entity);
        ArrayList<Object> params = new ArrayList<Object>();
        for (ColumnMeta column : sqlWithColumns.getColumns()) {
            params.add(columnsWithParam.get(column));
        }
        return new SqlWithParams(sqlWithColumns.getSql(), params);
    }

    public <T> BatchSqlWithColumns buildBatchInsertSql(Class<T> entityClass) {
        return this.buildInsertSqlWithColumns(entityClass, true);
    }

    public <T> BatchSqlWithColumns buildBatchInsertWithIdentityColumnSql(Class<T> entityClass) {
        return this.buildInsertSqlWithColumns(entityClass, false);
    }

    private <T> BatchSqlWithColumns buildInsertSqlWithColumns(Class<T> entityClass, boolean includeGeneratedColumn) {
        StringBuilder sql = new StringBuilder(512);
        sql.append("INSERT INTO ").append(this.toTableName(entityClass)).append('(');
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<ColumnMeta> columns = new ArrayList<ColumnMeta>();
        for (ColumnMeta column : EntityUtil.findAllColumns(entityClass)) {
            if (!includeGeneratedColumn && column.isGeneratedValue()) continue;
            columnNames.add(column.getName());
            values.add("?");
            columns.add(column);
        }
        sql.append(StringUtil.join((String)",", columnNames)).append(")VALUES(").append(StringUtil.join((String)",", values)).append(')');
        return new BatchSqlWithColumns(sql.toString(), columns);
    }

    protected <T> String buildIdCondition(Class<T> entityClass) {
        List<ColumnMeta> idColumns = EntityUtil.findIdColumns(entityClass);
        ArrayList<String> conditions = new ArrayList<String>(idColumns.size());
        for (ColumnMeta idColumn : idColumns) {
            conditions.add(idColumn.getName() + "=?");
        }
        return "WHERE " + StringUtil.join((String)" AND ", conditions);
    }

    protected <T> String toTableName(Class<T> entityClass) {
        if (entityClass.getAnnotation(Entity.class) == null) {
            throw new IllegalEntityException(entityClass + " isn't a entity class.");
        }
        return EntityUtil.getTableNameWithSchema(entityClass);
    }
}

