/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.GenerationType;
import javax.persistence.OptimisticLockException;
import nablarch.common.dao.BatchSqlWithColumns;
import nablarch.common.dao.ColumnMeta;
import nablarch.common.dao.DaoContext;
import nablarch.common.dao.DatabaseUtil;
import nablarch.common.dao.DeferredEntityList;
import nablarch.common.dao.EntityList;
import nablarch.common.dao.EntityUtil;
import nablarch.common.dao.IllegalEntityException;
import nablarch.common.dao.NoDataException;
import nablarch.common.dao.SqlResourceHolder;
import nablarch.common.dao.SqlWithParams;
import nablarch.common.dao.StandardSqlBuilder;
import nablarch.common.idgenerator.IdGenerator;
import nablarch.core.beans.BeanUtil;
import nablarch.core.beans.ConversionUtil;
import nablarch.core.db.DbAccessException;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.dialect.Dialect;
import nablarch.core.db.statement.ParameterizedSqlPStatement;
import nablarch.core.db.statement.ResultSetIterator;
import nablarch.core.db.statement.SelectOption;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.statement.SqlRow;

public class BasicDaoContext
implements DaoContext {
    private static final long DEFAULT_PER = 25L;
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private AppDbConnection dbConnection;
    private Long page;
    private Long per;
    private boolean defer = false;
    private final Map<GenerationType, IdGenerator> idGenerators = new EnumMap<GenerationType, IdGenerator>(GenerationType.class);
    private final StandardSqlBuilder sqlBuilder;
    private final Dialect dialect;

    BasicDaoContext(StandardSqlBuilder sqlBuilder, Dialect dialect) {
        this.sqlBuilder = sqlBuilder;
        this.dialect = dialect;
    }

    @Override
    public <T> T findById(Class<T> entityClass, Object ... id) {
        List<ColumnMeta> idColumns = EntityUtil.findIdColumns(entityClass);
        if (id.length != idColumns.size()) {
            throw new IllegalArgumentException("Mismatch the counts of id columns. expected=" + idColumns.size());
        }
        String sql = this.sqlBuilder.buildSelectByIdSql(entityClass);
        SqlPStatement stmt = this.dbConnection.prepareStatement(sql);
        for (int i = 0; i < idColumns.size(); ++i) {
            ColumnMeta meta = idColumns.get(i);
            stmt.setObject(i + 1, ConversionUtil.convert(meta.getJdbcType(), (Object)id[i]));
        }
        ResultSetIterator rsIter = stmt.executeQuery();
        if (!rsIter.next()) {
            throw new NoDataException();
        }
        SqlRow row = rsIter.getRow();
        return EntityUtil.createEntity(entityClass, row);
    }

    @Override
    public <T> EntityList<T> findAll(Class<T> entityClass) {
        String sql = this.sqlBuilder.buildSelectAllSql(entityClass);
        SqlPStatement stmt = this.dbConnection.prepareStatement(sql);
        SqlResourceHolder holder = new SqlResourceHolder(stmt.executeQuery());
        if (this.defer) {
            return new DeferredEntityList<T>(entityClass, holder);
        }
        EntityList<T> results = new EntityList<T>();
        ResultSetIterator rows = holder.getResultSetIterator();
        for (SqlRow row : rows) {
            results.add(EntityUtil.createEntity(entityClass, row));
        }
        return results;
    }

    @Override
    public <T> EntityList<T> findAllBySqlFile(Class<T> entityClass, String sqlId, Object params) {
        if (this.page == null) {
            return this.findAllBySqlFileWithoutPaginate(entityClass, sqlId, params);
        }
        return this.findAllBySqlFIleWithPaginate(entityClass, sqlId, params);
    }

    @Override
    public <T> EntityList<T> findAllBySqlFile(Class<T> entityClass, String sqlId) {
        return this.findAllBySqlFile(entityClass, sqlId, EMPTY_PARAMS);
    }

    protected SqlResourceHolder executeQuery(String normalizedSqlId, Object params, SelectOption selectOption) {
        if (params.getClass().isArray()) {
            Object[] paramsArray = (Object[])params;
            SqlPStatement stmt = this.dbConnection.prepareStatementBySqlId(normalizedSqlId, selectOption);
            for (int i = 0; i < paramsArray.length; ++i) {
                stmt.setObject(i + 1, paramsArray[i]);
            }
            return new SqlResourceHolder(stmt.executeQuery());
        }
        ParameterizedSqlPStatement stmt = this.dbConnection.prepareParameterizedSqlStatementBySqlId(normalizedSqlId, params, selectOption);
        if (params instanceof Map) {
            return new SqlResourceHolder(stmt.executeQueryByMap((Map)params));
        }
        return new SqlResourceHolder(stmt.executeQueryByObject(params));
    }

    protected <T> EntityList<T> findAllBySqlFileWithoutPaginate(Class<T> entityClass, String sqlId, Object params) {
        SqlResourceHolder holder = this.executeQuery(this.normalizeSqlId(sqlId, entityClass), params, new SelectOption(0, 0));
        if (this.defer) {
            return new DeferredEntityList<T>(entityClass, holder);
        }
        EntityList<T> results = new EntityList<T>();
        ResultSetIterator rows = holder.getResultSetIterator();
        for (SqlRow row : rows) {
            results.add(this.createResultInstance(entityClass, row));
        }
        results.setResultCount(results.size());
        return results;
    }

    private <T> T createResultInstance(Class<T> entityClass, SqlRow row) {
        if (entityClass.equals(SqlRow.class)) {
            SqlRow t = row;
            return (T)t;
        }
        return EntityUtil.createEntity(entityClass, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> EntityList<T> findAllBySqlFIleWithPaginate(Class<T> entityClass, String sqlId, Object params) {
        if (this.defer) {
            throw new IllegalArgumentException("Can't search with defer and pagination.");
        }
        long count = this.countBySqlFile(entityClass, sqlId, params);
        EntityList<T> results = new EntityList<T>();
        results.setPage(this.page);
        results.setMax(this.per);
        results.setResultCount(count);
        SqlResourceHolder holder = this.executeQuery(this.normalizeSqlId(sqlId, entityClass), params, new SelectOption(results.getPagination().getStartPosition(), results.getPagination().getMax().intValue()));
        try {
            for (SqlRow row : holder.getResultSetIterator()) {
                results.add(this.createResultInstance(entityClass, row));
            }
        }
        finally {
            holder.dispose();
        }
        return results;
    }

    @Override
    public <T> T findBySqlFile(Class<T> entityClass, String sqlId, Object params) {
        SqlResourceHolder holder = this.executeQuery(this.normalizeSqlId(sqlId, entityClass), params, new SelectOption(0, 0));
        try {
            ResultSetIterator rows = holder.getResultSetIterator();
            if (rows.next()) {
                SqlRow row = holder.getResultSetIterator().getRow();
                if (entityClass.equals(SqlRow.class)) {
                    SqlRow t;
                    SqlRow sqlRow = t = row;
                    return (T)sqlRow;
                }
                T t = EntityUtil.createEntity(entityClass, row);
                return t;
            }
            throw new NoDataException();
        }
        finally {
            holder.dispose();
        }
    }

    @Override
    public <T> long countBySqlFile(Class<T> entityClass, String sqlId, Object params) {
        ResultSetIterator rs;
        if (params.getClass().isArray()) {
            Object[] paramsArray = (Object[])params;
            SqlPStatement stmtCount = this.dbConnection.prepareCountStatementBySqlId(this.normalizeSqlId(sqlId, entityClass));
            for (int i = 0; i < paramsArray.length; ++i) {
                stmtCount.setObject(i + 1, paramsArray[i]);
            }
            rs = stmtCount.executeQuery();
        } else {
            ParameterizedSqlPStatement stmtCount = this.dbConnection.prepareParameterizedCountSqlStatementBySqlId(this.normalizeSqlId(sqlId, entityClass), params);
            rs = params instanceof Map ? stmtCount.executeQueryByMap((Map)params) : stmtCount.executeQueryByObject(params);
        }
        return this.getCountQueryResult(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCountQueryResult(ResultSetIterator rs) {
        long count;
        block4: {
            try {
                if (rs.next()) {
                    count = rs.getLong(1);
                    break block4;
                }
                throw new IllegalStateException("Count query didn't return result.");
            }
            finally {
                rs.close();
            }
        }
        return count;
    }

    @Override
    public <T> int update(T entity) throws OptimisticLockException {
        SqlWithParams sqlWithParams = this.sqlBuilder.buildUpdateSql(entity);
        SqlPStatement stmt = this.dbConnection.prepareStatement(sqlWithParams.getSql());
        for (int i = 0; i < sqlWithParams.getParams().size(); ++i) {
            stmt.setObject(i + 1, sqlWithParams.getParams().get(i));
        }
        int rows = stmt.executeUpdate();
        if (EntityUtil.findVersionColumn(entity) != null && rows == 0) {
            throw new OptimisticLockException();
        }
        return rows;
    }

    @Override
    public <T> void batchUpdate(List<T> entities) {
        if (entities.isEmpty()) {
            return;
        }
        Class<?> entityClass = entities.get(0).getClass();
        BatchSqlWithColumns sqlWithColumns = this.sqlBuilder.buildBatchUpdateSql(entityClass);
        SqlPStatement stmt = this.dbConnection.prepareStatement(sqlWithColumns.getSql());
        List<ColumnMeta> columns = sqlWithColumns.getColumns();
        for (T entity : entities) {
            BasicDaoContext.addBatchParameter(stmt, entity, columns);
        }
        stmt.executeBatch();
    }

    @Override
    public <T> void insert(T entity) {
        SqlPStatement stmt;
        SqlWithParams sqlWithParams;
        ColumnMeta generatedValueColumn = EntityUtil.findGeneratedValueColumn(entity);
        GenerationType generationType = this.findGeneratedType(generatedValueColumn);
        this.preInsert(entity, generationType);
        if (generationType == GenerationType.IDENTITY) {
            sqlWithParams = this.sqlBuilder.buildInsertWithIdentityColumnSql(entity);
            stmt = this.dbConnection.prepareStatement(sqlWithParams.getSql(), new String[]{DatabaseUtil.convertIdentifiers(generatedValueColumn.getName())});
        } else {
            sqlWithParams = this.sqlBuilder.buildInsertSql(entity);
            stmt = this.dbConnection.prepareStatement(sqlWithParams.getSql());
        }
        ListIterator<Object> valueIter = sqlWithParams.getParams().listIterator();
        int index = 1;
        while (valueIter.hasNext()) {
            stmt.setObject(index, valueIter.next());
            ++index;
        }
        stmt.executeUpdate();
        this.postInsert(entity, generationType, stmt);
    }

    @Override
    public <T> void batchInsert(List<T> entities) {
        SqlPStatement stmt;
        BatchSqlWithColumns sqlWithColumns;
        if (entities.isEmpty()) {
            return;
        }
        Class<?> entityClass = entities.get(0).getClass();
        ColumnMeta generatedValueColumn = EntityUtil.findGeneratedValueColumn(entityClass);
        GenerationType generationType = this.findGeneratedType(generatedValueColumn);
        if (!this.dialect.supportsIdentityWithBatchInsert() && generationType == GenerationType.IDENTITY) {
            throw new UnsupportedOperationException("batch insert to table with IDENTITY column is not supported.");
        }
        if (generationType == GenerationType.IDENTITY) {
            sqlWithColumns = this.sqlBuilder.buildBatchInsertWithIdentityColumnSql(entityClass);
            stmt = this.dbConnection.prepareStatement(sqlWithColumns.getSql(), new String[]{DatabaseUtil.convertIdentifiers(generatedValueColumn.getName())});
        } else {
            sqlWithColumns = this.sqlBuilder.buildBatchInsertSql(entityClass);
            stmt = this.dbConnection.prepareStatement(sqlWithColumns.getSql());
        }
        List<ColumnMeta> columns = sqlWithColumns.getColumns();
        for (T entity : entities) {
            this.preInsert(entity, generationType);
            BasicDaoContext.addBatchParameter(stmt, entity, columns);
        }
        stmt.executeBatch();
        this.postBatchInsert(entityClass, entities, generationType, stmt);
    }

    private GenerationType findGeneratedType(ColumnMeta generatedValueColumn) {
        GenerationType result;
        if (generatedValueColumn == null) {
            return null;
        }
        GenerationType type = generatedValueColumn.getGenerationType();
        if (type == GenerationType.AUTO) {
            result = this.getAutoType();
        } else if (type == GenerationType.SEQUENCE) {
            this.verifySequenceGenerator();
            result = type;
        } else if (type == GenerationType.IDENTITY) {
            this.verifyIdentityGenerator();
            result = type;
        } else {
            result = type;
        }
        return result;
    }

    private void verifyIdentityGenerator() {
        if (!this.dialect.supportsIdentity()) {
            throw new IllegalEntityException(MessageFormat.format("Unsupported GenerationType in dialect. GenerationType = {0}, Dialect class = {1}", GenerationType.IDENTITY, this.dialect.getClass().getName()));
        }
    }

    private void verifySequenceGenerator() {
        if (!this.dialect.supportsSequence()) {
            throw new IllegalEntityException(MessageFormat.format("Unsupported GenerationType in dialect. GenerationType = {0}, Dialect class = {1}", GenerationType.SEQUENCE, this.dialect.getClass().getName()));
        }
    }

    private GenerationType getAutoType() {
        if (this.dialect.supportsIdentity()) {
            return GenerationType.IDENTITY;
        }
        if (this.dialect.supportsSequence()) {
            return GenerationType.SEQUENCE;
        }
        return GenerationType.TABLE;
    }

    private <T> void preInsert(T entity, GenerationType generationType) {
        ColumnMeta versionColumn = EntityUtil.findVersionColumn(entity);
        if (versionColumn != null && Number.class.isAssignableFrom(versionColumn.getPropertyType())) {
            BeanUtil.setProperty(entity, (String)versionColumn.getPropertyName(), (Object)0L);
        }
        if (generationType == null || generationType == GenerationType.IDENTITY) {
            return;
        }
        ColumnMeta generatedValueColumn = EntityUtil.findGeneratedValueColumn(entity);
        IdGenerator generator = this.idGenerators.get(generationType);
        String id = generator.generateId(generatedValueColumn.getGeneratorName());
        BeanUtil.setProperty(entity, (String)generatedValueColumn.getPropertyName(), (Object)id);
    }

    private <T> void postInsert(T entity, GenerationType generationType, SqlPStatement statement) {
        if (generationType != GenerationType.IDENTITY) {
            return;
        }
        ColumnMeta generatedValueColumn = EntityUtil.findGeneratedValueColumn(entity);
        ResultSet keys = statement.getGeneratedKeys();
        try {
            if (keys.next()) {
                String id = keys.getString(1);
                BeanUtil.setProperty(entity, (String)generatedValueColumn.getPropertyName(), (Object)id);
            }
        }
        catch (SQLException e) {
            throw new DbAccessException("failed to get auto generated key. entity name = " + entity.getClass().getName(), e);
        }
        finally {
            if (keys != null) {
                try {
                    keys.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private <T> void postBatchInsert(Class<T> entityClass, Collection<T> entities, GenerationType generationType, SqlPStatement statement) {
        if (generationType != GenerationType.IDENTITY) {
            return;
        }
        ColumnMeta generatedValueColumn = EntityUtil.findGeneratedValueColumn(entityClass);
        ResultSet keys = statement.getGeneratedKeys();
        try {
            for (T entity : entities) {
                if (keys.next()) {
                    String id = keys.getString(1);
                    BeanUtil.setProperty(entity, (String)generatedValueColumn.getPropertyName(), (Object)id);
                    continue;
                }
                throw new IllegalStateException("generated key not found. entity name=[" + entityClass.getName() + ']');
            }
        }
        catch (SQLException e) {
            throw new DbAccessException("failed to get auto generated key. entity name = " + entityClass.getName(), e);
        }
        finally {
            if (keys != null) {
                try {
                    keys.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public <T> int delete(T entity) {
        SqlWithParams sqlWithParams = this.sqlBuilder.buildDeleteSql(entity);
        SqlPStatement stmt = this.dbConnection.prepareStatement(sqlWithParams.getSql());
        Iterator<Object> valueIter = sqlWithParams.getParams().iterator();
        int index = 1;
        while (valueIter.hasNext()) {
            stmt.setObject(index, valueIter.next());
            ++index;
        }
        return stmt.executeUpdate();
    }

    @Override
    public <T> void batchDelete(List<T> entities) {
        if (entities.isEmpty()) {
            return;
        }
        Class<?> entityClass = entities.get(0).getClass();
        BatchSqlWithColumns sqlWithColumns = this.sqlBuilder.buildBatchDeleteSql(entityClass);
        SqlPStatement stmt = this.dbConnection.prepareStatement(sqlWithColumns.getSql());
        List<ColumnMeta> columns = sqlWithColumns.getColumns();
        for (T entity : entities) {
            BasicDaoContext.addBatchParameter(stmt, entity, columns);
        }
        stmt.executeBatch();
    }

    private static <T> void addBatchParameter(SqlPStatement statement, T entity, List<ColumnMeta> columns) {
        Map<ColumnMeta, Object> columnValues = EntityUtil.findAllColumns(entity);
        int index = 1;
        for (ColumnMeta column : columns) {
            statement.setObject(index, columnValues.get(column));
            ++index;
        }
        statement.addBatch();
    }

    public <T> String tableName(T entity) {
        Class<?> entityClass = entity.getClass();
        if (entityClass.getAnnotation(Entity.class) == null) {
            throw new IllegalEntityException(entityClass + " isn't a entity class.");
        }
        return EntityUtil.getTableName(entityClass);
    }

    @Override
    public DaoContext page(long page) {
        this.page = page;
        if (this.per == null) {
            this.per = 25L;
        }
        return this;
    }

    @Override
    public DaoContext per(long per) {
        this.per = per;
        return this;
    }

    @Override
    public DaoContext defer() {
        this.defer = true;
        return this;
    }

    protected <T> String normalizeSqlId(String sqlId, Class<T> entityClass) {
        if (sqlId.contains("#")) {
            return sqlId;
        }
        return entityClass.getName() + '#' + sqlId;
    }

    protected void setIdGenerator(GenerationType type, IdGenerator generator) {
        this.idGenerators.put(type, generator);
    }

    protected void setDbConnection(AppDbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

