/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import javax.persistence.GenerationType;
import nablarch.common.dao.BasicDaoContext;
import nablarch.common.dao.DaoContext;
import nablarch.common.dao.DaoContextFactory;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.connection.DbConnectionContext;
import nablarch.core.db.connection.TransactionManagerConnection;
import nablarch.core.db.dialect.Dialect;

public class BasicDaoContextFactory
extends DaoContextFactory {
    @Override
    public DaoContext create() {
        AppDbConnection appDbConnection = (AppDbConnection)this.dbConnection.get();
        if (appDbConnection == null) {
            appDbConnection = DbConnectionContext.getConnection();
        }
        Dialect dialect = ((TransactionManagerConnection)appDbConnection).getDialect();
        BasicDaoContext daoContext = new BasicDaoContext(this.sqlBuilder, dialect);
        daoContext.setDbConnection(appDbConnection);
        if (this.sequenceIdGenerator != null) {
            daoContext.setIdGenerator(GenerationType.SEQUENCE, this.sequenceIdGenerator);
        }
        if (this.tableIdGenerator != null) {
            daoContext.setIdGenerator(GenerationType.TABLE, this.tableIdGenerator);
        }
        return daoContext;
    }
}

