/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import javax.persistence.GenerationType;
import nablarch.common.dao.EntityMeta;
import nablarch.common.dao.JpaAnnotationParam;
import nablarch.core.util.annotation.Published;

@Published(tag={"architect"})
public class ColumnMeta {
    private final EntityMeta entityMeta;
    private final JpaAnnotationParam jpaAnnotationParam;

    public ColumnMeta(EntityMeta entityMeta, JpaAnnotationParam jpaAnnotationParam) {
        this.entityMeta = entityMeta;
        this.jpaAnnotationParam = jpaAnnotationParam;
    }

    public String getName() {
        return this.jpaAnnotationParam.getColumnName();
    }

    public String getPropertyName() {
        return this.jpaAnnotationParam.getName();
    }

    public Class<?> getJdbcType() {
        return this.jpaAnnotationParam.getJdbcType();
    }

    public Class<?> getPropertyType() {
        return this.jpaAnnotationParam.getPropertyType();
    }

    protected boolean isTransient() {
        return this.jpaAnnotationParam.isTransient();
    }

    public boolean isIdColumn() {
        return this.jpaAnnotationParam.isIdColumn();
    }

    public boolean isVersion() {
        return this.jpaAnnotationParam.isVersionColumn();
    }

    public boolean isGeneratedValue() {
        return this.jpaAnnotationParam.getGenerationType() != null;
    }

    public GenerationType getGenerationType() {
        return this.jpaAnnotationParam.getGenerationType();
    }

    public String getGeneratorName() {
        return this.jpaAnnotationParam.getGeneratorName();
    }

    public boolean equals(Object another) {
        if (another == null || !(another instanceof ColumnMeta)) {
            return false;
        }
        ColumnMeta anotherMeta = (ColumnMeta)ColumnMeta.class.cast(another);
        return this.jpaAnnotationParam.getColumnName().equals(anotherMeta.getName()) && this.entityMeta.equals(anotherMeta.entityMeta);
    }

    public int hashCode() {
        return this.jpaAnnotationParam.getColumnName().hashCode() + this.entityMeta.hashCode();
    }
}

