/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import nablarch.common.dao.NamingConversionUtil;
import nablarch.core.util.StringUtil;

class JpaAnnotationParam {
    private static final List<Class<? extends Annotation>> JOIN_COLUMN_ANNOTATIONS = Arrays.asList(JoinColumn.class, OneToMany.class, ManyToOne.class, ManyToMany.class, OneToOne.class);
    private static final Map<TemporalType, Class<?>> TEMPORAL_TYPE_MAP = new EnumMap(TemporalType.class);
    private final GeneratedValueMetaData generatedValueMetaData;
    private final String name;
    private final boolean isJoinColumn;
    private final Class<?> propertyType;
    private final Class<?> jdbcType;
    private final String columnName;
    private final boolean isTransientColumn;
    private final boolean isIdColumn;
    private final boolean isVersionColumn;

    JpaAnnotationParam(String tableName, PropertyDescriptor propertyDescriptor, Annotation[] annotations) {
        this.name = propertyDescriptor.getName();
        this.isJoinColumn = JpaAnnotationParam.isJoinColumn(annotations);
        this.propertyType = propertyDescriptor.getPropertyType();
        this.jdbcType = JpaAnnotationParam.getJdbcType(annotations, propertyDescriptor);
        this.columnName = JpaAnnotationParam.getColumnName(annotations, propertyDescriptor);
        this.isTransientColumn = JpaAnnotationParam.getAnnotation(annotations, Transient.class) != null;
        this.isIdColumn = JpaAnnotationParam.getAnnotation(annotations, Id.class) != null;
        this.isVersionColumn = JpaAnnotationParam.getAnnotation(annotations, Version.class) != null;
        this.generatedValueMetaData = this.createGeneratedValueMetaData(tableName, annotations);
    }

    private static boolean isJoinColumn(Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            if (!JOIN_COLUMN_ANNOTATIONS.contains(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    boolean isJoinColumn() {
        return this.isJoinColumn;
    }

    String getName() {
        return this.name;
    }

    Class<?> getPropertyType() {
        return this.propertyType;
    }

    private static Class<?> getJdbcType(Annotation[] annotations, PropertyDescriptor propertyDescriptor) {
        Temporal temporal = JpaAnnotationParam.getAnnotation(annotations, Temporal.class);
        if (temporal == null) {
            return propertyDescriptor.getPropertyType();
        }
        return TEMPORAL_TYPE_MAP.get(temporal.value());
    }

    Class<?> getJdbcType() {
        return this.jdbcType;
    }

    private static String getColumnName(Annotation[] annotations, PropertyDescriptor propertyDescriptor) {
        Column column = JpaAnnotationParam.getAnnotation(annotations, Column.class);
        if (column != null && StringUtil.hasValue((String)column.name())) {
            return column.name();
        }
        return NamingConversionUtil.deCamelize(propertyDescriptor.getName());
    }

    String getColumnName() {
        return this.columnName;
    }

    boolean isTransient() {
        return this.isTransientColumn;
    }

    boolean isIdColumn() {
        return this.isIdColumn;
    }

    boolean isVersionColumn() {
        return this.isVersionColumn;
    }

    private static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationClassName) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationClassName)) continue;
            return (T)annotation;
        }
        return null;
    }

    String getGeneratorName() {
        return this.generatedValueMetaData != null ? this.generatedValueMetaData.generatorName : null;
    }

    GenerationType getGenerationType() {
        return this.generatedValueMetaData != null ? this.generatedValueMetaData.generationType : null;
    }

    private GeneratedValueMetaData createGeneratedValueMetaData(String tableName, Annotation[] annotations) {
        GeneratedValue generatedValue = JpaAnnotationParam.getAnnotation(annotations, GeneratedValue.class);
        if (generatedValue != null) {
            return new GeneratedValueMetaData(tableName, generatedValue, annotations);
        }
        return null;
    }

    static {
        TEMPORAL_TYPE_MAP.put(TemporalType.DATE, Date.class);
        TEMPORAL_TYPE_MAP.put(TemporalType.TIME, Time.class);
        TEMPORAL_TYPE_MAP.put(TemporalType.TIMESTAMP, Timestamp.class);
    }

    private final class GeneratedValueMetaData {
        private final GenerationType generationType;
        private final String generatorName;

        private GeneratedValueMetaData(String tableName, GeneratedValue generatedValue, Annotation[] annotations) {
            String generator = generatedValue.generator();
            String columnName = JpaAnnotationParam.this.getColumnName();
            switch (generatedValue.strategy()) {
                case AUTO: {
                    if (this.getSequenceGenerator(annotations, generator) != null) {
                        this.generationType = GenerationType.SEQUENCE;
                        this.generatorName = this.buildSequenceName(tableName, columnName, this.getSequenceGenerator(annotations, generator));
                        break;
                    }
                    if (this.findTableGenerator(annotations, generator) != null) {
                        this.generationType = GenerationType.TABLE;
                        this.generatorName = this.buildTableGeneratorName(tableName, columnName, this.findTableGenerator(annotations, generator));
                        break;
                    }
                    this.generationType = GenerationType.AUTO;
                    this.generatorName = tableName + '_' + columnName;
                    break;
                }
                case IDENTITY: {
                    this.generationType = GenerationType.IDENTITY;
                    this.generatorName = null;
                    break;
                }
                case SEQUENCE: {
                    this.generationType = GenerationType.SEQUENCE;
                    this.generatorName = this.buildSequenceName(tableName, columnName, this.getSequenceGenerator(annotations, generator));
                    break;
                }
                case TABLE: {
                    this.generationType = GenerationType.TABLE;
                    this.generatorName = this.buildTableGeneratorName(tableName, columnName, this.findTableGenerator(annotations, generator));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected value: " + generatedValue);
                }
            }
        }

        private SequenceGenerator getSequenceGenerator(Annotation[] annotations, String generator) {
            SequenceGenerator sequenceGenerator = (SequenceGenerator)JpaAnnotationParam.getAnnotation(annotations, SequenceGenerator.class);
            if (sequenceGenerator == null) {
                return null;
            }
            return generator.equals(sequenceGenerator.name()) ? sequenceGenerator : null;
        }

        private TableGenerator findTableGenerator(Annotation[] annotations, String generator) {
            TableGenerator tableGenerator = (TableGenerator)JpaAnnotationParam.getAnnotation(annotations, TableGenerator.class);
            if (tableGenerator == null) {
                return null;
            }
            return generator.equals(tableGenerator.name()) ? tableGenerator : null;
        }

        private String buildSequenceName(String tableName, String columnName, SequenceGenerator sequenceGenerator) {
            if (sequenceGenerator != null && StringUtil.hasValue((String)sequenceGenerator.sequenceName())) {
                return sequenceGenerator.sequenceName();
            }
            return tableName + '_' + columnName;
        }

        private String buildTableGeneratorName(String tableName, String columnName, TableGenerator tableGenerator) {
            if (tableGenerator != null && StringUtil.hasValue((String)tableGenerator.pkColumnValue())) {
                return tableGenerator.pkColumnValue();
            }
            return tableName + '_' + columnName;
        }
    }
}

