/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.dao;

import java.util.List;
import nablarch.common.dao.BasicDaoContextFactory;
import nablarch.common.dao.DaoContext;
import nablarch.common.dao.DaoContextFactory;
import nablarch.common.dao.EntityList;
import nablarch.common.dao.EntityUtil;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.transaction.SimpleDbTransactionExecutor;
import nablarch.core.db.transaction.SimpleDbTransactionManager;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.annotation.Published;

@Published
public final class UniversalDao {
    private static final String DAO_CONTEXT_FACTORY = "daoContextFactory";
    private static final Object[] EMPTY_PARAM = new Object[0];

    private UniversalDao() {
    }

    private static DaoContext daoContext() {
        DaoContextFactory factory = (DaoContextFactory)SystemRepository.get((String)DAO_CONTEXT_FACTORY);
        return factory != null ? factory.create() : new BasicDaoContextFactory().create();
    }

    public static <T> T findById(Class<T> entityClass, Object ... id) {
        if (id.length == 1 || EntityUtil.findEntityMeta(entityClass).canFindById()) {
            return UniversalDao.daoContext().findById(entityClass, id);
        }
        throw new IllegalStateException("For findById, enable to get the orders of primary keys.");
    }

    public static <T> EntityList<T> findAll(Class<T> entityClass) {
        return UniversalDao.daoContext().findAll(entityClass);
    }

    public static <T> EntityList<T> findAllBySqlFile(Class<T> entityClass, String sqlId, Object params) {
        return UniversalDao.daoContext().findAllBySqlFile(entityClass, sqlId, params);
    }

    public static <T> EntityList<T> findAllBySqlFile(Class<T> entityClass, String sqlId) {
        return UniversalDao.daoContext().findAllBySqlFile(entityClass, sqlId, EMPTY_PARAM);
    }

    public static <T> T findBySqlFile(Class<T> entityClass, String sqlId, Object params) {
        return UniversalDao.daoContext().findBySqlFile(entityClass, sqlId, params);
    }

    public static <T> long countBySqlFile(Class<T> entityClass, String sqlId) {
        return UniversalDao.countBySqlFile(entityClass, sqlId, EMPTY_PARAM);
    }

    public static <T> long countBySqlFile(Class<T> entityClass, String sqlId, Object params) {
        return UniversalDao.daoContext().countBySqlFile(entityClass, sqlId, params);
    }

    public static <T> boolean exists(Class<T> entityClass, String sqlId) {
        return UniversalDao.exists(entityClass, sqlId, EMPTY_PARAM);
    }

    public static <T> boolean exists(Class<T> entityClass, String sqlId, Object params) {
        return UniversalDao.countBySqlFile(entityClass, sqlId, params) > 0L;
    }

    public static <T> int update(T entity) {
        return UniversalDao.daoContext().update(entity);
    }

    public static <T> void batchUpdate(List<T> entities) {
        UniversalDao.daoContext().batchUpdate(entities);
    }

    public static <T> void insert(T entity) {
        UniversalDao.daoContext().insert(entity);
    }

    public static <T> void batchInsert(List<T> entities) {
        UniversalDao.daoContext().batchInsert(entities);
    }

    public static <T> int delete(T entity) {
        return UniversalDao.daoContext().delete(entity);
    }

    public static <T> void batchDelete(List<T> entities) {
        UniversalDao.daoContext().batchDelete(entities);
    }

    public static DaoContext page(long page) {
        return UniversalDao.daoContext().page(page);
    }

    public static DaoContext per(long per) {
        return UniversalDao.daoContext().per(per);
    }

    public static DaoContext defer() {
        return UniversalDao.daoContext().defer();
    }

    public static abstract class Transaction
    extends SimpleDbTransactionExecutor<Void> {
        public Transaction(SimpleDbTransactionManager transactionManager) {
            super(transactionManager);
            this.doTransaction();
        }

        public Transaction(String transactionManagerName) {
            this((SimpleDbTransactionManager)SystemRepository.get((String)transactionManagerName));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void execute(AppDbConnection connection) {
            DaoContextFactory daoContextFactory = (DaoContextFactory)SystemRepository.get((String)UniversalDao.DAO_CONTEXT_FACTORY);
            if (daoContextFactory == null) {
                throw new IllegalStateException("Transaction feature requires DaoContextFactory is registered to the SystemRepository.");
            }
            AppDbConnection origConn = daoContextFactory.getDbConnection();
            daoContextFactory.setDbConnection(connection);
            try {
                this.execute();
                Void void_ = null;
                return void_;
            }
            finally {
                daoContextFactory.setDbConnection(origConn);
            }
        }

        protected abstract void execute();
    }
}

