/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.encryption;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import nablarch.common.encryption.Base64Key;
import nablarch.common.encryption.Encryptor;
import nablarch.core.util.StringUtil;

public class AesEncryptor
implements Encryptor<AesContext> {
    private static final int KEY_LENGTH = 128;
    private static final String CIPHER_ALGORITHM = "AES";
    private static final String CIPHER_MODE = "CBC";
    private static final String CIPHER_PADDING = "PKCS5Padding";
    private static final String TRANSFORMATION = String.format("%s/%s/%s", "AES", "CBC", "PKCS5Padding");
    private static final SecureRandom RANDOM;
    private static final String RANDOM_ALGORITHM = "SHA1PRNG";
    private String key;
    private String iv;
    private Base64Key base64key;

    @Deprecated
    public void setKey(String key) {
        this.key = key;
    }

    public void setBase64Key(Base64Key base64Key) {
        this.base64key = base64Key;
    }

    @Deprecated
    public void setIv(String iv) {
        this.iv = iv;
    }

    @Override
    public AesContext generateContext() {
        return new AesContext(this.generateKey(128), this.generateIv(128));
    }

    @Override
    public byte[] encrypt(AesContext context, byte[] src) {
        if (context == null || src == null) {
            throw new IllegalArgumentException("context or src is null.");
        }
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, context.getKey(), new IvParameterSpec(context.getIv()));
            return cipher.doFinal(src);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(String.format("encryption failed. transformation = [%s]", TRANSFORMATION), e);
        }
    }

    @Override
    public byte[] decrypt(AesContext context, byte[] src) {
        if (context == null || src == null) {
            throw new IllegalArgumentException("context or src is null.");
        }
        try {
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, context.getKey(), new IvParameterSpec(context.getIv()));
            return cipher.doFinal(src);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException(String.format("decryption failed. transformation = [%s]", TRANSFORMATION), e);
        }
    }

    protected byte[] getBytes(String text) {
        return text.getBytes(Charset.forName("UTF-8"));
    }

    protected Key generateKey(int length) {
        if (this.base64key != null && this.base64key.getKey() != null) {
            return new SecretKeySpec(this.base64key.getKey(), CIPHER_ALGORITHM);
        }
        if (StringUtil.hasValue((String)this.key)) {
            return new SecretKeySpec(this.getBytes(this.key), CIPHER_ALGORITHM);
        }
        try {
            KeyGenerator generator = KeyGenerator.getInstance(CIPHER_ALGORITHM);
            generator.init(length, RANDOM);
            return generator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(String.format("key generating failed. cipher algorithm = [%s]", CIPHER_ALGORITHM), e);
        }
    }

    protected byte[] generateIv(int length) {
        if (this.base64key != null && this.base64key.getIv() != null) {
            return this.base64key.getIv();
        }
        if (StringUtil.hasValue((String)this.iv)) {
            return this.getBytes(this.iv);
        }
        byte[] iv = new byte[length / 8];
        RANDOM.nextBytes(iv);
        return iv;
    }

    static {
        try {
            RANDOM = SecureRandom.getInstance(RANDOM_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SecureRandom initialization failed.", e);
        }
    }

    public static final class AesContext
    implements Serializable {
        private final Key key;
        private final byte[] iv;

        public AesContext(Key key, byte[] iv) {
            this.key = key;
            this.iv = iv;
        }

        public Key getKey() {
            return this.key;
        }

        public byte[] getIv() {
            return this.iv;
        }
    }
}

