/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.idgenerator;

import nablarch.common.idgenerator.IdFormatter;
import nablarch.common.idgenerator.IdGenerator;
import nablarch.common.idgenerator.TableIdGenerator;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.transaction.SimpleDbTransactionExecutor;
import nablarch.core.db.transaction.SimpleDbTransactionManager;
import nablarch.core.repository.initialization.Initializable;

public class FastTableIdGenerator
implements IdGenerator,
Initializable {
    private SimpleDbTransactionManager dbTransactionManager;
    private TableIdGenerator tableIdGenerator;
    private String tableName;
    private String idColumnName;
    private String noColumnName;

    public String generateId(String id) {
        return this.generateId(id, null);
    }

    public String generateId(final String id, final IdFormatter formatter) {
        try {
            return (String)new SimpleDbTransactionExecutor<String>(this.dbTransactionManager){

                public String execute(AppDbConnection connection) {
                    return FastTableIdGenerator.this.tableIdGenerator.generateId(id, formatter);
                }
            }.doTransaction();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("failed in generation of id. id = " + id, e);
        }
        catch (Error e) {
            throw new RuntimeException("failed in generation of id. id = " + id, e);
        }
    }

    public void setDbTransactionManager(SimpleDbTransactionManager dbTransactionManager) {
        this.dbTransactionManager = dbTransactionManager;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName.toUpperCase();
    }

    public void setIdColumnName(String idColumnName) {
        this.idColumnName = idColumnName.toUpperCase();
    }

    public void setNoColumnName(String noColumnName) {
        this.noColumnName = noColumnName.toUpperCase();
    }

    public void initialize() {
        if ("transaction".equals(this.dbTransactionManager.getDbTransactionName())) {
            this.dbTransactionManager.setDbTransactionName(this.getClass().getName());
        }
        this.tableIdGenerator = new TableIdGenerator();
        this.tableIdGenerator.setTableName(this.tableName);
        this.tableIdGenerator.setIdColumnName(this.idColumnName);
        this.tableIdGenerator.setNoColumnName(this.noColumnName);
        this.tableIdGenerator.setDbTransactionName(this.dbTransactionManager.getDbTransactionName());
        this.tableIdGenerator.initialize();
    }
}

