/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.idgenerator;

import nablarch.common.idgenerator.IdFormatter;
import nablarch.common.idgenerator.IdGenerator;
import nablarch.core.db.connection.DbConnectionContext;
import nablarch.core.db.connection.TransactionManagerConnection;
import nablarch.core.db.statement.ResultSetIterator;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;

public class SequenceIdGenerator
implements IdGenerator {
    private String dbTransactionName = "transaction";
    private static final Logger LOGGER = LoggerManager.get(SequenceIdGenerator.class);

    public String generateId(String sequenceName) {
        return this.generateId(sequenceName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateId(String sequenceName, IdFormatter formatter) {
        TransactionManagerConnection connection = DbConnectionContext.getTransactionManagerConnection((String)this.dbTransactionName);
        SqlPStatement statement = connection.prepareStatement(connection.getDialect().buildSequenceGeneratorSql(sequenceName));
        ResultSetIterator rs = statement.executeQuery();
        if (!rs.next()) {
            throw new SequenceGeneratorFailedException(sequenceName);
        }
        try {
            String id = String.valueOf(rs.getLong(1));
            if (formatter == null) {
                String string = id;
                return string;
            }
            String string = formatter.format(sequenceName, id);
            return string;
        }
        finally {
            try {
                rs.close();
            }
            catch (RuntimeException e) {
                LOGGER.logWarn("failed to ResultSetIterator#close", (Throwable)e, new Object[0]);
            }
        }
    }

    public void setDbTransactionName(String dbTransactionName) {
        this.dbTransactionName = dbTransactionName;
    }

    public static class SequenceGeneratorFailedException
    extends RuntimeException {
        private static final String MESSAGE = "failed to get next value from sequence. sequence name=";

        public SequenceGeneratorFailedException(String sequenceName) {
            super("failed to get next value from sequence. sequence name=[" + sequenceName + ']');
        }
    }
}

