/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.idgenerator;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nablarch.common.idgenerator.IdFormatter;
import nablarch.common.idgenerator.IdGenerator;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.connection.DbConnectionContext;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.statement.SqlResultSet;
import nablarch.core.db.statement.SqlRow;
import nablarch.core.util.annotation.Published;

@Deprecated
public abstract class SequenceIdGeneratorSupport
implements IdGenerator {
    private Map<String, String> idTable;
    private String dbTransactionName = "transaction";
    private final Map<String, String> sqlCache = new ConcurrentHashMap<String, String>();

    @Published(tag={"architect"})
    protected SequenceIdGeneratorSupport() {
    }

    public String generateId(String id) {
        return this.generateId(id, null);
    }

    public String generateId(String id, IdFormatter formatter) {
        if (this.idTable == null || this.idTable.get(id) == null) {
            throw new IllegalArgumentException(String.format("id was not found. id:%s", id));
        }
        AppDbConnection connection = DbConnectionContext.getConnection((String)this.dbTransactionName);
        SqlPStatement statement = connection.prepareStatement(this.getSql(this.idTable.get(id)));
        SqlResultSet resultSet = statement.retrieve(1, 1);
        String generateId = ((SqlRow)resultSet.get(0)).getString("GENERATE_ID");
        if (formatter != null) {
            return formatter.format(id, generateId);
        }
        return generateId;
    }

    public void setIdTable(Map<String, String> idTable) {
        for (Map.Entry<String, String> entry : idTable.entrySet()) {
            String name = entry.getValue();
            if (name.indexOf(" ") == -1) continue;
            throw new IllegalArgumentException(String.format("invalid sequence name. id = %s, sequence name = %s", entry.getKey(), name));
        }
        this.idTable = idTable;
    }

    public void setDbTransactionName(String dbTransactionName) {
        this.dbTransactionName = dbTransactionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSql(String sequenceName) {
        String sql = this.sqlCache.get(sequenceName);
        if (sql != null) {
            return sql;
        }
        Map<String, String> map = this.sqlCache;
        synchronized (map) {
            sql = this.sqlCache.get(sequenceName);
            if (sql != null) {
                return sql;
            }
            sql = this.createSql(sequenceName);
            this.sqlCache.put(sequenceName, sql);
        }
        return sql;
    }

    @Published(tag={"architect"})
    protected abstract String createSql(String var1);
}

