/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.idgenerator;

import nablarch.common.idgenerator.IdFormatter;
import nablarch.common.idgenerator.IdGenerator;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.connection.DbConnectionContext;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.statement.SqlResultSet;
import nablarch.core.db.statement.SqlRow;
import nablarch.core.repository.initialization.Initializable;

public class TableIdGenerator
implements IdGenerator,
Initializable {
    private String tableName;
    private String idColumnName;
    private String noColumnName;
    private String dbTransactionName = "transaction";
    private String updateSql;
    private String selectSql;

    public void setTableName(String tableName) {
        this.tableName = tableName.toUpperCase();
    }

    public void setIdColumnName(String idColumnName) {
        this.idColumnName = idColumnName.toUpperCase();
    }

    public void setNoColumnName(String noColumnName) {
        this.noColumnName = noColumnName.toUpperCase();
    }

    public void setDbTransactionName(String dbTransactionName) {
        this.dbTransactionName = dbTransactionName;
    }

    public void initialize() {
        String tmpUpdateSql = "  UPDATE $TABLE_NAME$    SET $NO$ = $NO$ + 1  WHERE $ID$ = ?";
        this.updateSql = tmpUpdateSql.replace("$TABLE_NAME$", this.tableName).replace("$NO$", this.noColumnName).replace("$ID$", this.idColumnName);
        String tmpSelectSql = "  SELECT $NO$   FROM $TABLE_NAME$  WHERE $ID$ = ?";
        this.selectSql = tmpSelectSql.replace("$TABLE_NAME$", this.tableName).replace("$NO$", this.noColumnName).replace("$ID$", this.idColumnName);
    }

    public String generateId(String id) {
        return this.generate(id);
    }

    public String generateId(String id, IdFormatter formatter) {
        String no = this.generate(id);
        if (formatter == null) {
            return no;
        }
        return formatter.format(id, no);
    }

    private String generate(String id) {
        AppDbConnection connection = DbConnectionContext.getConnection((String)this.dbTransactionName);
        SqlPStatement update = connection.prepareStatement(this.updateSql);
        update.setString(1, id);
        if (update.executeUpdate() != 1) {
            throw new IllegalStateException(String.format("id was not found. id:%s", id));
        }
        SqlPStatement select = connection.prepareStatement(this.selectSql);
        select.setString(1, id);
        SqlResultSet rs = select.retrieve(1, 1);
        return ((SqlRow)rs.get(0)).getString(this.noColumnName);
    }
}

