/*
 * Decompiled with CFR 0.152.
 */
package nablarch.common.handler;

import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.connection.ConnectionFactory;
import nablarch.core.db.connection.DbConnectionContext;
import nablarch.core.db.connection.TransactionManagerConnection;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.StringUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.InboundHandleable;
import nablarch.fw.OutboundHandleable;
import nablarch.fw.Result;

public class DbConnectionManagementHandler
implements Handler<Object, Object>,
InboundHandleable,
OutboundHandleable {
    private ConnectionFactory connectionFactory;
    private String connectionName = "transaction";
    private static final Logger LOGGER = LoggerManager.get(DbConnectionManagementHandler.class);

    public DbConnectionManagementHandler setConnectionFactory(ConnectionFactory connectionFactory) {
        assert (connectionFactory != null);
        this.connectionFactory = connectionFactory;
        return this;
    }

    public void setConnectionName(String connectionName) {
        assert (!StringUtil.isNullOrEmpty((String)connectionName));
        this.connectionName = connectionName;
    }

    public Object handle(Object inputData, ExecutionContext ctx) {
        this.before();
        Throwable throwable = null;
        try {
            Object object = ctx.handleNext(inputData);
            return object;
        }
        catch (RuntimeException e) {
            throwable = e;
            throw e;
        }
        catch (Error e) {
            throwable = e;
            throw e;
        }
        finally {
            try {
                this.after();
            }
            catch (RuntimeException e) {
                DbConnectionManagementHandler.writeWarnLog(throwable);
                throw e;
            }
            catch (Error e) {
                DbConnectionManagementHandler.writeWarnLog(throwable);
                throw e;
            }
        }
    }

    public void before() {
        if (DbConnectionContext.containConnection((String)this.connectionName)) {
            throw new IllegalStateException("The specified database connection name is already used. connection name=[" + this.connectionName + ']');
        }
        DbConnectionContext.setConnection((String)this.connectionName, (AppDbConnection)this.connectionFactory.getConnection(this.connectionName));
    }

    public void after() {
        TransactionManagerConnection connection = DbConnectionContext.getTransactionManagerConnection((String)this.connectionName);
        DbConnectionContext.removeConnection((String)this.connectionName);
        connection.terminate();
    }

    private static void writeWarnLog(Throwable throwable) {
        if (throwable != null) {
            LOGGER.logWarn("DbConnectionManagementHandler#handle failed in the application process.", throwable, new Object[0]);
        }
    }

    public Result handleInbound(ExecutionContext context) {
        this.before();
        return new Result.Success();
    }

    public Result handleOutbound(ExecutionContext context) {
        this.after();
        return new Result.Success();
    }
}

