/*
 * Decompiled with CFR 0.152.
 */
package nablarch.core.date;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nablarch.core.ThreadContext;
import nablarch.core.date.BusinessDateProvider;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.connection.DbConnectionContext;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.statement.SqlResultSet;
import nablarch.core.db.statement.SqlRow;
import nablarch.core.db.transaction.SimpleDbTransactionExecutor;
import nablarch.core.db.transaction.SimpleDbTransactionManager;
import nablarch.core.repository.SystemRepository;
import nablarch.core.repository.initialization.Initializable;
import nablarch.core.util.DateUtil;
import nablarch.core.util.StringUtil;

public class BasicBusinessDateProvider
implements BusinessDateProvider,
Initializable {
    private String tableName;
    private String segmentColumnName;
    private String dateColumnName;
    private String defaultSegment;
    private String selectSql;
    private String selectAllSql;
    private String updateDateSql;
    private boolean cacheEnabled = true;
    private String dbTransactionName = "transaction";
    private SimpleDbTransactionManager transactionManager;
    private static final String CACHE_KEY = "BUSINESS_DATE";
    private static final String CLASS_NAME = BasicBusinessDateProvider.class.getSimpleName();
    private static Set<String> validSegment = new HashSet<String>();

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setSegmentColumnName(String segmentColumnName) {
        this.segmentColumnName = segmentColumnName;
    }

    public void setDateColumnName(String dateColumnName) {
        this.dateColumnName = dateColumnName;
    }

    public void setDefaultSegment(String defaultSegment) {
        this.defaultSegment = defaultSegment;
    }

    public void setCacheEnabled(boolean cache) {
        this.cacheEnabled = cache;
    }

    public void setDbTransactionName(String dbTransactionName) {
        this.dbTransactionName = dbTransactionName;
    }

    public void setDbTransactionManager(SimpleDbTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getDate() {
        return this.getDate(this.defaultSegment);
    }

    public String getDate(final String segment) {
        String date = BasicBusinessDateProvider.getRepositoryDate(segment);
        if (date != null) {
            return date;
        }
        if (this.cacheEnabled) {
            Map<String, String> data = this.getCacheData();
            if (!data.containsKey(segment)) {
                throw new IllegalStateException(String.format("segment was not found. segment:%s.", segment));
            }
            return data.get(segment);
        }
        if (!DbConnectionContext.containConnection((String)this.dbTransactionName)) {
            this.transactionManager.setDbTransactionName(this.dbTransactionName);
            return (String)new SimpleDbTransactionExecutor<String>(this.transactionManager){

                public String execute(AppDbConnection connection) {
                    return BasicBusinessDateProvider.this.getDateBySegment(connection, segment);
                }
            }.doTransaction();
        }
        AppDbConnection con = DbConnectionContext.getConnection((String)this.dbTransactionName);
        return this.getDateBySegment(con, segment);
    }

    private String getDateBySegment(AppDbConnection connection, String segment) throws IllegalStateException {
        SqlPStatement select = connection.prepareStatement(this.selectSql);
        select.setString(1, segment);
        SqlResultSet resultSet = select.retrieve();
        if (resultSet.isEmpty()) {
            throw new IllegalStateException(String.format("segment was not found. segment:%s.", segment));
        }
        return ((SqlRow)resultSet.get(0)).getString(this.dateColumnName);
    }

    public Map<String, String> getAllDate() {
        if (this.cacheEnabled) {
            return this.getCacheData();
        }
        return this.getAllBusinessDate();
    }

    private Map<String, String> getAllBusinessDate() {
        SqlResultSet resultSet;
        if (!DbConnectionContext.containConnection((String)this.dbTransactionName)) {
            this.transactionManager.setDbTransactionName(this.dbTransactionName);
            resultSet = (SqlResultSet)new SimpleDbTransactionExecutor<SqlResultSet>(this.transactionManager){

                public SqlResultSet execute(AppDbConnection connection) {
                    return BasicBusinessDateProvider.this.getDateByUnCondition(connection);
                }
            }.doTransaction();
        } else {
            AppDbConnection con = DbConnectionContext.getConnection((String)this.dbTransactionName);
            resultSet = this.getDateByUnCondition(con);
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (SqlRow row : resultSet) {
            String segment = row.getString(this.segmentColumnName);
            String date = BasicBusinessDateProvider.getRepositoryDate(segment);
            if (date == null) {
                date = row.getString(this.dateColumnName);
            }
            ret.put(segment, date);
        }
        return ret;
    }

    private SqlResultSet getDateByUnCondition(AppDbConnection connection) throws IllegalStateException {
        SqlPStatement select = connection.prepareStatement(this.selectAllSql);
        SqlResultSet resultSet = select.retrieve();
        if (resultSet.isEmpty()) {
            throw new IllegalStateException("business date was not registered.");
        }
        return resultSet;
    }

    public void setDate(final String segment, final String date) throws IllegalArgumentException {
        if (segment == null) {
            throw new IllegalArgumentException("segment was null.");
        }
        if (date == null) {
            throw new IllegalArgumentException("date was null.");
        }
        if (segment.length() == 0) {
            throw new IllegalArgumentException("segment was empty.");
        }
        if (date.length() == 0) {
            throw new IllegalArgumentException("date was empty.");
        }
        if (!DateUtil.isValid((String)date, (String)"yyyyMMdd")) {
            throw new IllegalArgumentException("date was not formatted 'yyyyMMdd' or non existent date. date:" + date + ".");
        }
        if (!DbConnectionContext.containConnection((String)this.dbTransactionName)) {
            this.transactionManager.setDbTransactionName(this.dbTransactionName);
            new SimpleDbTransactionExecutor<Void>(this.transactionManager){

                public Void execute(AppDbConnection connection) {
                    BasicBusinessDateProvider.this.updateDate(segment, date, connection);
                    return null;
                }
            }.doTransaction();
        } else {
            AppDbConnection con = DbConnectionContext.getConnection((String)this.dbTransactionName);
            this.updateDate(segment, date, con);
        }
    }

    private void updateDate(String segment, String date, AppDbConnection connection) {
        SqlPStatement updateDate = connection.prepareStatement(this.updateDateSql);
        updateDate.setString(1, date);
        updateDate.setString(2, segment);
        int updateCount = updateDate.executeUpdate();
        if (updateCount == 0) {
            throw new IllegalStateException("segment was not found. segment:" + segment + '.');
        }
    }

    public void initialize() {
        String tmpSql = "SELECT $DATE_COL$ FROM $TABLE_NAME$ WHERE $SEGMENT_COL$ = ?";
        this.selectSql = tmpSql.replace("$DATE_COL$", this.dateColumnName).replace("$TABLE_NAME$", this.tableName).replace("$SEGMENT_COL$", this.segmentColumnName);
        tmpSql = "SELECT $SEGMENT_COL$, $DATE_COL$ FROM $TABLE_NAME$ ";
        this.selectAllSql = tmpSql.replace("$SEGMENT_COL$", this.segmentColumnName).replace("$DATE_COL$", this.dateColumnName).replace("$TABLE_NAME$", this.tableName);
        tmpSql = "UPDATE $TABLE_NAME$ SET $DATE_COL$ = ? WHERE $SEGMENT_COL$ = ?";
        this.updateDateSql = tmpSql.replace("$TABLE_NAME$", this.tableName).replace("$DATE_COL$", this.dateColumnName).replace("$SEGMENT_COL$", this.segmentColumnName);
    }

    private static String getRepositoryDate(String segment) {
        String date = SystemRepository.getString((String)(CLASS_NAME + '.' + segment));
        if (StringUtil.isNullOrEmpty((String)date)) {
            return null;
        }
        if (validSegment.contains(date)) {
            return date;
        }
        if (!DateUtil.isValid((String)date, (String)"yyyyMMdd")) {
            throw new IllegalStateException("business date in system repository was invalid. date=[" + date + "] segment=[" + segment + "]");
        }
        validSegment.add(date);
        return date;
    }

    private Map<String, String> getCacheData() {
        Map tableData = (Map)ThreadContext.getObject((String)CACHE_KEY);
        if (tableData != null) {
            return tableData;
        }
        Map<String, String> date = this.getAllBusinessDate();
        ThreadContext.setObject((String)CACHE_KEY, date);
        return date;
    }
}

