/*
 * Decompiled with CFR 0.152.
 */
package nablarch.core.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nablarch.core.cache.StaticDataLoader;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.connection.DbConnectionContext;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.statement.SqlResultSet;
import nablarch.core.db.statement.SqlRow;
import nablarch.core.db.transaction.SimpleDbTransactionExecutor;
import nablarch.core.db.transaction.SimpleDbTransactionManager;
import nablarch.core.message.BasicStringResource;
import nablarch.core.message.StringResource;

public class BasicStringResourceLoader
implements StaticDataLoader<StringResource> {
    private SimpleDbTransactionManager dbManager;
    private String tableName;
    private String idColumnName;
    private String langColumnName;
    private String valueColumnName;
    private boolean idQueryCreated = false;
    private String selectByIdQuery = null;

    public void setDbManager(SimpleDbTransactionManager dbManager) {
        this.dbManager = dbManager;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.idQueryCreated = false;
    }

    public void setIdColumnName(String idColumnName) {
        this.idColumnName = idColumnName;
        this.idQueryCreated = false;
    }

    public void setLangColumnName(String langColumnName) {
        this.langColumnName = langColumnName;
        this.idQueryCreated = false;
    }

    public void setValueColumnName(String valueColumnName) {
        this.valueColumnName = valueColumnName;
        this.idQueryCreated = false;
    }

    public Object getId(StringResource value) {
        return value.getId();
    }

    public Object generateIndexKey(String indexName, StringResource value) {
        return null;
    }

    public List<String> getIndexNames() {
        return null;
    }

    public StringResource getValue(final Object id) {
        boolean requireTransaction = !DbConnectionContext.containConnection((String)this.dbManager.getDbTransactionName());
        SqlResultSet resultSet = requireTransaction ? (SqlResultSet)new SimpleDbTransactionExecutor<SqlResultSet>(this.dbManager){

            public SqlResultSet execute(AppDbConnection connection) {
                return BasicStringResourceLoader.this.getMessage(id);
            }
        }.doTransaction() : this.getMessage(id);
        List<StringResource> messages = this.createMessage(resultSet);
        return messages.isEmpty() ? null : messages.get(0);
    }

    private SqlResultSet getMessage(Object id) {
        AppDbConnection connection = DbConnectionContext.getConnection((String)this.dbManager.getDbTransactionName());
        if (!this.idQueryCreated) {
            this.selectByIdQuery = "SELECT " + this.idColumnName + ", " + this.langColumnName + ", " + this.valueColumnName + " " + " FROM " + this.tableName + " " + " WHERE " + this.idColumnName + " = ? " + " ORDER BY " + this.idColumnName + ", " + this.langColumnName;
            this.idQueryCreated = true;
        }
        SqlPStatement prepared = connection.prepareStatement(this.selectByIdQuery);
        prepared.setString(1, id.toString());
        return prepared.retrieve();
    }

    public List<StringResource> getValues(String indexName, Object key) {
        return null;
    }

    public List<StringResource> loadAll() {
        SqlResultSet resultSet = (SqlResultSet)new SimpleDbTransactionExecutor<SqlResultSet>(this.dbManager){

            public SqlResultSet execute(AppDbConnection connection) {
                String selectAllQuery = "SELECT " + BasicStringResourceLoader.this.idColumnName + ", " + BasicStringResourceLoader.this.langColumnName + ", " + BasicStringResourceLoader.this.valueColumnName + " " + " FROM " + BasicStringResourceLoader.this.tableName + " " + " ORDER BY " + BasicStringResourceLoader.this.idColumnName + ", " + BasicStringResourceLoader.this.langColumnName;
                SqlPStatement prepared = connection.prepareStatement(selectAllQuery);
                return prepared.retrieve();
            }
        }.doTransaction();
        return this.createMessage(resultSet);
    }

    private List<StringResource> createMessage(SqlResultSet results) {
        ArrayList<StringResource> msgs = new ArrayList<StringResource>(results.size());
        if (results.isEmpty()) {
            return msgs;
        }
        HashMap<String, String> formatMap = null;
        String msgId = null;
        for (SqlRow row : results) {
            String currentMsgId = row.getString(this.idColumnName);
            String lang = row.getString(this.langColumnName);
            String value = row.getString(this.valueColumnName);
            if (!currentMsgId.equals(msgId)) {
                String prevMsgId = msgId;
                msgId = currentMsgId;
                if (prevMsgId != null) {
                    BasicStringResource msg = new BasicStringResource(prevMsgId, formatMap);
                    msgs.add((StringResource)msg);
                }
                formatMap = new HashMap<String, String>();
            }
            formatMap.put(lang, value);
        }
        BasicStringResource msg = new BasicStringResource(msgId, formatMap);
        msgs.add((StringResource)msg);
        return msgs;
    }
}

