/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.action;

import nablarch.core.db.support.DbAccessSupport;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.log.app.FailureLogUtil;
import nablarch.core.message.Message;
import nablarch.core.message.MessageLevel;
import nablarch.core.message.MessageUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Result;
import nablarch.fw.TransactionEventCallback;
import nablarch.fw.handler.ExecutionHandlerCallback;
import nablarch.fw.launcher.CommandLine;

public abstract class BatchActionBase<D>
extends DbAccessSupport
implements ExecutionHandlerCallback<CommandLine, Result>,
TransactionEventCallback<D> {
    private static final Logger LOG = LoggerManager.get(BatchActionBase.class);

    @Published
    protected void initialize(CommandLine command, ExecutionContext context) {
    }

    @Published
    protected void error(Throwable error, ExecutionContext context) {
    }

    @Published
    protected void terminate(Result result, ExecutionContext context) {
    }

    @Published
    protected void transactionSuccess(D inputData, ExecutionContext context) {
    }

    @Published
    protected void transactionFailure(D inputData, ExecutionContext context) {
    }

    @Published
    protected void writeLog(String msgId, Object ... msgOptions) {
        Message message = MessageUtil.createMessage((MessageLevel)MessageLevel.INFO, (String)msgId, (Object[])msgOptions);
        LOG.logInfo(message.formatMessage(), new Object[0]);
    }

    @Published
    protected void writeErrorLog(Object data, String failureCode, Object ... msgOptions) {
        FailureLogUtil.logError((Object)data, (String)failureCode, (Object[])msgOptions);
    }

    @Published
    protected void writeFatalLog(Object data, String failureCode, Object ... msgOptions) {
        FailureLogUtil.logFatal((Object)data, (String)failureCode, (Object[])msgOptions);
    }

    @Published(tag={"architect"})
    public final void preExecution(CommandLine commandLine, ExecutionContext context) {
        this.initialize(commandLine, context);
    }

    @Published(tag={"architect"})
    public final void errorInExecution(Throwable error, ExecutionContext context) {
        this.error(error, context);
    }

    @Published(tag={"architect"})
    public final void postExecution(Result result, ExecutionContext context) {
        this.terminate(result, context);
    }

    @Published(tag={"architect"})
    public void transactionNormalEnd(D data, ExecutionContext ctx) {
        this.transactionSuccess(data, ctx);
    }

    @Published(tag={"architect"})
    public void transactionAbnormalEnd(Throwable e, D data, ExecutionContext ctx) {
        this.transactionFailure(data, ctx);
    }
}

