/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.transaction.SimpleDbTransactionExecutor;
import nablarch.core.db.transaction.SimpleDbTransactionManager;
import nablarch.core.repository.initialization.Initializable;
import nablarch.fw.handler.AlreadyProcessRunningException;
import nablarch.fw.handler.DuplicateProcessChecker;

public class BasicDuplicateProcessChecker
implements DuplicateProcessChecker,
Initializable {
    private SimpleDbTransactionManager dbTransactionManager;
    private String tableName;
    private String processIdentifierColumnName;
    private String processActiveFlgColumnName;
    private String activeSql;
    private String inactiveSql;
    private List<String> permitProcessIdentifier = Collections.emptyList();

    public void initialize() {
        this.activeSql = this.buildActiveSql();
        this.inactiveSql = this.buildInactiveSql();
    }

    private String buildActiveSql() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("$tableName$", this.tableName);
        replace.put("$processIdentifierColumnName$", this.processIdentifierColumnName);
        replace.put("$processActiveFlgColumnName$", this.processActiveFlgColumnName);
        String activeSqlTemplate = "update $tableName$ set $processActiveFlgColumnName$ = '1' where $processIdentifierColumnName$ = ? and $processActiveFlgColumnName$ = '0'";
        StringBuffer sql = new StringBuffer(256);
        Matcher matcher = Pattern.compile("\\$[a-zA-Z]+\\$").matcher("update $tableName$ set $processActiveFlgColumnName$ = '1' where $processIdentifierColumnName$ = ? and $processActiveFlgColumnName$ = '0'");
        while (matcher.find()) {
            matcher.appendReplacement(sql, (String)replace.get(matcher.group(0)));
        }
        matcher.appendTail(sql);
        return sql.toString();
    }

    private String buildInactiveSql() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("$tableName$", this.tableName);
        replace.put("$processIdentifierColumnName$", this.processIdentifierColumnName);
        replace.put("$processActiveFlgColumnName$", this.processActiveFlgColumnName);
        String inactiveSqlTemplate = "update $tableName$ set $processActiveFlgColumnName$ = '0' where $processIdentifierColumnName$ = ? and $processActiveFlgColumnName$ = '1'";
        StringBuffer sql = new StringBuffer(256);
        Matcher matcher = Pattern.compile("\\$[a-zA-Z]+\\$").matcher("update $tableName$ set $processActiveFlgColumnName$ = '0' where $processIdentifierColumnName$ = ? and $processActiveFlgColumnName$ = '1'");
        while (matcher.find()) {
            matcher.appendReplacement(sql, (String)replace.get(matcher.group(0)));
        }
        matcher.appendTail(sql);
        return sql.toString();
    }

    public void setDbTransactionManager(SimpleDbTransactionManager dbTransactionManager) {
        this.dbTransactionManager = dbTransactionManager;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setProcessIdentifierColumnName(String processIdentifierColumnName) {
        this.processIdentifierColumnName = processIdentifierColumnName;
    }

    public void setProcessActiveFlgColumnName(String processActiveFlgColumnName) {
        this.processActiveFlgColumnName = processActiveFlgColumnName;
    }

    public void setPermitProcessIdentifier(String[] permitProcessIdentifier) {
        this.permitProcessIdentifier = Arrays.asList(permitProcessIdentifier);
    }

    @Override
    public void checkAndActive(String processIdentifier) throws AlreadyProcessRunningException {
        if (this.isPermitProcess(processIdentifier)) {
            return;
        }
        if (this.isDuplicateProcess(processIdentifier)) {
            throw new AlreadyProcessRunningException("same process already running. process = [" + processIdentifier + ']');
        }
    }

    private boolean isDuplicateProcess(final String processIdentifier) {
        return (Boolean)new SimpleDbTransactionExecutor<Boolean>(this.dbTransactionManager){

            public Boolean execute(AppDbConnection connection) {
                SqlPStatement statement = connection.prepareStatement(BasicDuplicateProcessChecker.this.activeSql);
                statement.setString(1, processIdentifier);
                return statement.executeUpdate() != 1;
            }
        }.doTransaction();
    }

    @Override
    public void inactive(final String processIdentifier) {
        if (this.isPermitProcess(processIdentifier)) {
            return;
        }
        new SimpleDbTransactionExecutor<Void>(this.dbTransactionManager){

            public Void execute(AppDbConnection connection) {
                SqlPStatement statement = connection.prepareStatement(BasicDuplicateProcessChecker.this.inactiveSql);
                statement.setString(1, processIdentifier);
                statement.executeUpdate();
                return null;
            }
        }.doTransaction();
    }

    private boolean isPermitProcess(String processIdentifier) {
        return this.permitProcessIdentifier.contains(processIdentifier);
    }
}

