/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import nablarch.core.ThreadContext;
import nablarch.core.db.connection.AppDbConnection;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.statement.SqlResultSet;
import nablarch.core.db.transaction.SimpleDbTransactionExecutor;
import nablarch.core.db.transaction.SimpleDbTransactionManager;
import nablarch.core.repository.initialization.Initializable;
import nablarch.fw.ExecutionContext;
import nablarch.fw.handler.ProcessStopHandler;

public class BasicProcessStopHandler
implements ProcessStopHandler,
Initializable {
    private static final String PROCESS_STOP = "1";
    private int checkInterval = 1;
    private SimpleDbTransactionManager dbTransactionManager;
    private String tableName;
    private String requestIdColumnName;
    private String processHaltColumnName;
    private String query;
    private int exitCode = 1;
    private final ThreadLocal<Integer> count = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public Object handle(Object o, ExecutionContext context) {
        int nowCount = this.count.get();
        if (nowCount++ % this.checkInterval == 0) {
            if (this.isProcessStop(ThreadContext.getRequestId())) {
                throw new ProcessStopHandler.ProcessStop(this.exitCode);
            }
            nowCount = 1;
        }
        this.count.set(nowCount);
        return context.handleNext(o);
    }

    public boolean isProcessStop(final String requestId) {
        return (Boolean)new SimpleDbTransactionExecutor<Boolean>(this.dbTransactionManager){

            public Boolean execute(AppDbConnection connection) {
                SqlPStatement statement = connection.prepareStatement(BasicProcessStopHandler.this.query);
                statement.setString(1, requestId);
                statement.setString(2, BasicProcessStopHandler.PROCESS_STOP);
                SqlResultSet retrieve = statement.retrieve();
                return !retrieve.isEmpty();
            }
        }.doTransaction();
    }

    public void setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval <= 0 ? 1 : checkInterval;
    }

    public void setDbTransactionManager(SimpleDbTransactionManager dbTransactionManager) {
        this.dbTransactionManager = dbTransactionManager;
    }

    public void initialize() {
        String query;
        this.query = query = "SELECT " + this.requestIdColumnName + " FROM " + this.tableName + " WHERE " + this.requestIdColumnName + " = ?" + " AND " + this.processHaltColumnName + " = ?";
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setRequestIdColumnName(String requestIdColumnName) {
        this.requestIdColumnName = requestIdColumnName;
    }

    public void setProcessHaltColumnName(String processHaltColumnName) {
        this.processHaltColumnName = processHaltColumnName;
    }

    public void setExitCode(int exitCode) {
        if (exitCode <= 0 || exitCode >= 256) {
            throw new IllegalArgumentException("exit code was invalid range. please set it in the range of 255 from 1. specified value was:" + exitCode);
        }
        this.exitCode = exitCode;
    }
}

