/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.handler;

import nablarch.core.ThreadContext;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.handler.AlreadyProcessRunningException;
import nablarch.fw.handler.DuplicateProcessChecker;
import nablarch.fw.results.InternalError;

public class DuplicateProcessCheckHandler
implements Handler<Object, Object> {
    private int exitCode = 500;
    private DuplicateProcessChecker duplicateProcessChecker;
    private static final Logger LOGGER = LoggerManager.get(DuplicateProcessCheckHandler.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object handle(Object o, ExecutionContext context) {
        boolean bl;
        Object object;
        try {
            this.duplicateProcessChecker.checkAndActive(ThreadContext.getRequestId());
        }
        catch (AlreadyProcessRunningException ignored) {
            throw new DuplicateProcess(this.exitCode);
        }
        Throwable originalError = null;
        try {
            object = context.handleNext(o);
            bl = originalError != null;
        }
        catch (RuntimeException e) {
            try {
                originalError = e;
                throw e;
                catch (Error e2) {
                    originalError = e2;
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.inactive(originalError != null);
                throw throwable;
            }
        }
        this.inactive(bl);
        return object;
    }

    private void inactive(boolean throwException) {
        block2: {
            try {
                this.duplicateProcessChecker.inactive(ThreadContext.getRequestId());
            }
            catch (Throwable t) {
                LOGGER.logWarn("failed to disable process.", t, new Object[0]);
                if (throwException) break block2;
                throw new RuntimeException(t);
            }
        }
    }

    public void setExitCode(int exitCode) {
        if (exitCode <= 0 || exitCode >= 256) {
            throw new IllegalArgumentException("exit code was invalid range. Please set it in the range of 255 from 1. specified value was:" + exitCode);
        }
        this.exitCode = exitCode;
    }

    public void setDuplicateProcessChecker(DuplicateProcessChecker duplicateProcessChecker) {
        this.duplicateProcessChecker = duplicateProcessChecker;
    }

    @Published(tag={"architect"})
    public static class DuplicateProcess
    extends InternalError {
        private int exitCode;

        public DuplicateProcess(int exitCode) {
            super("specified request_id is already used by another process. you can not start two or more processes with same request_id.");
            this.exitCode = exitCode;
        }

        public int getStatusCode() {
            return this.exitCode;
        }
    }
}

