/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.reader;

import java.util.Iterator;
import java.util.Map;
import nablarch.core.db.statement.ParameterizedSqlPStatement;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.statement.SqlRow;
import nablarch.core.util.annotation.Published;
import nablarch.fw.DataReader;
import nablarch.fw.ExecutionContext;
import nablarch.fw.reader.DatabaseRecordListener;

public class DatabaseRecordReader
implements DataReader<SqlRow> {
    private Iterator<SqlRow> records = null;
    private SqlPStatement statement;
    private ParameterizedSqlPStatement parameterizedSqlPStatement;
    private Object condition;
    private DatabaseRecordListener listener;

    @Published
    public DatabaseRecordReader() {
    }

    public synchronized SqlRow read(ExecutionContext ctx) {
        if (this.records == null) {
            this.readRecords();
        }
        return this.records.hasNext() ? this.records.next() : null;
    }

    public synchronized boolean hasNext(ExecutionContext ctx) {
        if (this.records == null) {
            this.readRecords();
        }
        return this.records.hasNext();
    }

    public synchronized void close(ExecutionContext ctx) {
        if (this.statement != null) {
            this.statement.close();
        }
    }

    public synchronized void reopen(ExecutionContext ctx) {
        this.readRecords();
    }

    private void readRecords() {
        if (this.listener != null) {
            this.listener.beforeReadRecords();
        }
        if (this.statement != null) {
            this.records = this.statement.executeQuery().iterator();
        } else if (this.parameterizedSqlPStatement != null) {
            this.records = this.condition instanceof Map ? this.parameterizedSqlPStatement.executeQueryByMap((Map)this.condition).iterator() : this.parameterizedSqlPStatement.executeQueryByObject(this.condition).iterator();
        } else {
            throw new IllegalStateException("Statement was not set.");
        }
    }

    @Published
    public synchronized DatabaseRecordReader setStatement(SqlPStatement statement) {
        this.statement = statement;
        return this;
    }

    @Published
    public DatabaseRecordReader setStatement(ParameterizedSqlPStatement parameterizedSqlPStatement, Object condition) {
        this.parameterizedSqlPStatement = parameterizedSqlPStatement;
        this.condition = condition;
        return this;
    }

    @Published
    public DatabaseRecordReader setListener(DatabaseRecordListener listener) {
        this.listener = listener;
        return this;
    }
}

