/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.reader;

import java.io.File;
import nablarch.core.dataformat.DataRecord;
import nablarch.core.dataformat.FileRecordReader;
import nablarch.core.util.FilePathSetting;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.DataReader;
import nablarch.fw.ExecutionContext;

public class FileDataReader
implements DataReader<DataRecord> {
    private FileRecordReader fileReader;
    private String layoutFileName = null;
    private String dataFileName = null;
    private int bufferSize = 8192;
    private String layoutFileBasePathName;
    private String dataFileBasePathName;

    @Published(tag={"architect"})
    public FileDataReader() {
    }

    public synchronized DataRecord read(ExecutionContext ctx) {
        if (this.fileReader == null) {
            this.fileReader = this.createFileRecordReader();
        }
        DataRecord record = null;
        if (this.fileReader.hasNext()) {
            record = this.fileReader.read();
        }
        ctx.setLastRecordNumber(this.fileReader.getRecordNumber());
        return record;
    }

    public synchronized boolean hasNext(ExecutionContext ctx) {
        if (this.fileReader == null) {
            this.fileReader = this.createFileRecordReader();
        }
        return this.fileReader.hasNext();
    }

    public synchronized void close(ExecutionContext ctx) {
        if (this.fileReader == null) {
            return;
        }
        ctx.setLastRecordNumber(this.fileReader.getRecordNumber());
        this.fileReader.close();
    }

    @Published(tag={"architect"})
    public FileDataReader setLayoutFile(String layoutFile) {
        return this.setLayoutFile("format", layoutFile);
    }

    @Published(tag={"architect"})
    public FileDataReader setLayoutFile(String basePathName, String fileName) {
        this.layoutFileBasePathName = basePathName;
        this.layoutFileName = fileName;
        return this;
    }

    @Published(tag={"architect"})
    public FileDataReader setDataFile(String fileName) {
        return this.setDataFile("input", fileName);
    }

    @Published(tag={"architect"})
    public FileDataReader setDataFile(String basePathName, String fileName) {
        this.dataFileBasePathName = basePathName;
        this.dataFileName = fileName;
        return this;
    }

    @Published(tag={"architect"})
    public FileDataReader setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    protected FileRecordReader createFileRecordReader() {
        if (StringUtil.isNullOrEmpty((String)this.dataFileName)) {
            throw new IllegalStateException("data file name was blank. data file name must not be blank.");
        }
        if (StringUtil.isNullOrEmpty((String)this.layoutFileName)) {
            throw new IllegalStateException("layout file name was blank. layout file name must not be blank.");
        }
        if (StringUtil.isNullOrEmpty((String)this.dataFileBasePathName)) {
            throw new IllegalStateException("data file base path name was blank. data file base path name must not be blank.");
        }
        if (StringUtil.isNullOrEmpty((String)this.layoutFileBasePathName)) {
            throw new IllegalStateException("layout file base path name was blank. layout file base path name must not be blank.");
        }
        FilePathSetting filePathSetting = FilePathSetting.getInstance();
        File dataFile = filePathSetting.getFileWithoutCreate(this.dataFileBasePathName, this.dataFileName);
        File layoutFile = filePathSetting.getFileWithoutCreate(this.layoutFileBasePathName, this.layoutFileName);
        return new FileRecordReader(dataFile, layoutFile, this.bufferSize);
    }

    protected synchronized FileRecordReader getFileReader() {
        return this.fileReader;
    }

    protected synchronized void setFileReader(FileRecordReader fileReader) {
        this.fileReader = fileReader;
    }
}

