/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.reader;

import nablarch.core.ThreadContext;
import nablarch.core.util.Builder;
import nablarch.fw.DataReader;
import nablarch.fw.ExecutionContext;
import nablarch.fw.handler.LoopHandler;
import nablarch.fw.reader.ResumePointManager;

public class ResumeDataReader<TData>
implements DataReader<TData> {
    private DataReader<TData> sourceReader = null;
    private ResumePointManager resumePointManager;
    private int resumePoint = 0;

    public synchronized TData read(ExecutionContext ctx) {
        if (!this.sourceReader.hasNext(ctx)) {
            return null;
        }
        if (this.resumePointManager == null) {
            this.resumePointManager = ResumePointManager.getInstance();
            this.readToResumePoint(ctx);
        }
        Object readData = this.sourceReader.read(ctx);
        ++this.resumePoint;
        if (LoopHandler.isAboutToCommit((ExecutionContext)ctx)) {
            this.saveResumePoint();
        }
        return (TData)readData;
    }

    public synchronized boolean hasNext(ExecutionContext ctx) {
        return this.sourceReader.hasNext(ctx);
    }

    public synchronized void close(ExecutionContext ctx) {
        this.sourceReader.close(ctx);
    }

    protected void readToResumePoint(ExecutionContext ctx) {
        int numberOfReads;
        this.resumePoint = this.loadResumePoint();
        for (numberOfReads = 0; numberOfReads < this.resumePoint; ++numberOfReads) {
            if (!this.sourceReader.hasNext(ctx)) {
                throw new IllegalStateException(this.getInvalidResumePointMessage(this.resumePoint, numberOfReads));
            }
            this.sourceReader.read(ctx);
        }
        if (!this.sourceReader.hasNext(ctx)) {
            throw new IllegalStateException(this.getInvalidResumePointMessage(this.resumePoint, numberOfReads) + " Perhaps this request has been completed.");
        }
    }

    private String getInvalidResumePointMessage(int resumePoint, int numberOfReads) {
        return Builder.concat((Object[])new Object[]{"invalid resume point was specified. ", "The total number of reads input data was [", numberOfReads, "], ", "but resume point was [", resumePoint, "]. ", "request id=[", ThreadContext.getRequestId(), "]."});
    }

    protected int loadResumePoint() {
        return this.resumePointManager.loadResumePoint(ThreadContext.getRequestId());
    }

    protected void saveResumePoint() {
        this.resumePointManager.saveResumePoint(ThreadContext.getRequestId(), this.resumePoint);
    }

    public synchronized ResumeDataReader<TData> setSourceReader(DataReader<TData> sourceReader) {
        this.sourceReader = sourceReader;
        return this;
    }
}

