/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.reader;

import java.util.ArrayList;
import java.util.List;
import nablarch.core.ThreadContext;
import nablarch.core.db.connection.DbConnectionContext;
import nablarch.core.db.statement.SqlPStatement;
import nablarch.core.db.statement.SqlResultSet;
import nablarch.core.db.statement.SqlRow;
import nablarch.core.repository.SystemRepository;
import nablarch.core.repository.initialization.Initializable;
import nablarch.core.util.Builder;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;

@Published(tag={"architect"})
public class ResumePointManager
implements Initializable {
    private static final String REPOSITORY_KEY = "resumePointManager";
    private static final ResumePointManager NOP_MANAGER = new ResumePointManager();
    private String dbTransactionName = "transaction";
    private String tableName;
    private String requestIdColumnName;
    private String resumePointColumnName;
    private String loadResumePointSql;
    private String saveResumePointSql;
    private boolean isResumable = false;
    private List<String> excludingRequestList = new ArrayList<String>();

    public static ResumePointManager getInstance() {
        ResumePointManager manager = (ResumePointManager)SystemRepository.get((String)REPOSITORY_KEY);
        if (manager == null) {
            return NOP_MANAGER;
        }
        return manager;
    }

    public void initialize() {
        this.checkPropertySet("tableName", this.tableName);
        this.checkPropertySet("requestIdColumnName", this.requestIdColumnName);
        this.checkPropertySet("resumePointColumnName", this.resumePointColumnName);
        this.loadResumePointSql = this.buildLoadResumePointSql();
        this.saveResumePointSql = this.buildSaveResumePointSql();
    }

    protected void checkPropertySet(String name, String value) throws IllegalStateException {
        if (StringUtil.isNullOrEmpty((String)value)) {
            throw new IllegalStateException(String.format("[%s] property must be set. class=[%s].", name, this.getClass().getName()));
        }
    }

    public int loadResumePoint(String requestId) {
        if (!this.isResumable(requestId)) {
            return 0;
        }
        this.checkSingleThreadExecution(requestId);
        SqlPStatement statement = DbConnectionContext.getConnection((String)this.dbTransactionName).prepareStatement(this.loadResumePointSql);
        statement.setString(1, requestId);
        SqlResultSet retrieve = statement.retrieve();
        if (retrieve.size() != 1) {
            throw new IllegalStateException(String.format("Couldn't load resume point from the table. sql=[%s], request id=[%s].", this.loadResumePointSql, requestId));
        }
        int resumePoint = ((SqlRow)retrieve.get(0)).getBigDecimal(this.resumePointColumnName).intValue();
        if (resumePoint < 0) {
            throw new IllegalStateException(String.format("invalid resume point was stored on the table. resume point must be more than 0. resume point=[%s], sql=[%s], request id=[%s].", resumePoint, this.loadResumePointSql, requestId));
        }
        return resumePoint;
    }

    protected void checkSingleThreadExecution(String requestId) throws IllegalStateException {
        boolean isMultiThread;
        int concurrentNumber = ThreadContext.getConcurrentNumber();
        boolean bl = isMultiThread = concurrentNumber > 1;
        if (isMultiThread) {
            throw new IllegalStateException(String.format("Cannot use resume function in multi thread. resume function is operated only in single thread. concurrent number=[%s], request id=[%s].", concurrentNumber, requestId));
        }
    }

    public void saveResumePoint(String requestId, int resumePoint) {
        if (!this.isResumable(requestId)) {
            return;
        }
        SqlPStatement statement = DbConnectionContext.getConnection((String)this.dbTransactionName).prepareStatement(this.saveResumePointSql);
        statement.setInt(1, resumePoint);
        statement.setString(2, requestId);
        int updateCount = statement.executeUpdate();
        if (updateCount != 1) {
            throw new IllegalStateException(String.format("Couldn't save resume point. sql=[%s], request id=[%s].", this.saveResumePointSql, requestId));
        }
    }

    protected boolean isResumable(String requestId) {
        return this.isResumable && !this.excludingRequestList.contains(requestId);
    }

    protected String buildLoadResumePointSql() {
        return Builder.concat((Object[])new Object[]{"SELECT ", this.resumePointColumnName, " FROM ", this.tableName, " WHERE ", this.requestIdColumnName, " = ?"});
    }

    protected String buildSaveResumePointSql() {
        return Builder.concat((Object[])new Object[]{"UPDATE ", this.tableName, " SET ", this.resumePointColumnName, " = ?", " WHERE ", this.requestIdColumnName, " = ?"});
    }

    public ResumePointManager setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public ResumePointManager setRequestIdColumnName(String requestIdColumnName) {
        this.requestIdColumnName = requestIdColumnName;
        return this;
    }

    public ResumePointManager setResumePointColumnName(String resumePointColumnName) {
        this.resumePointColumnName = resumePointColumnName;
        return this;
    }

    public ResumePointManager setResumable(boolean isResumable) {
        this.isResumable = isResumable;
        return this;
    }

    public ResumePointManager setExcludingRequestList(List<String> excludingRequestList) {
        this.excludingRequestList = excludingRequestList;
        return this;
    }

    public ResumePointManager setDbTransactionName(String dbTransactionName) {
        this.dbTransactionName = dbTransactionName;
        return this;
    }
}

