/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.reader;

import java.util.LinkedList;
import java.util.List;
import nablarch.core.dataformat.DataRecord;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.MethodBinder;
import nablarch.fw.reader.FileDataReader;

public class ValidatableFileDataReader
extends FileDataReader {
    private static final Logger LOGGER = LoggerManager.get(ValidatableFileDataReader.class);
    private FileValidatorAction validatorAction = null;
    private boolean useCache = false;
    private List<DataRecord> recordCache = null;
    private boolean validated = false;

    @Published(tag={"architect"})
    public ValidatableFileDataReader() {
    }

    @Override
    public synchronized DataRecord read(ExecutionContext ctx) {
        if (!this.validated) {
            this.validate(ctx);
        }
        if (this.useCache) {
            return this.recordCache == null || this.recordCache.isEmpty() ? null : this.recordCache.remove(0);
        }
        return super.read(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasNext(ExecutionContext ctx) {
        if (this.validated && this.useCache) {
            ValidatableFileDataReader validatableFileDataReader = this;
            synchronized (validatableFileDataReader) {
                return this.recordCache == null ? false : !this.recordCache.isEmpty();
            }
        }
        return super.hasNext(ctx);
    }

    @Override
    public synchronized void close(ExecutionContext ctx) {
        if (this.useCache) {
            this.recordCache.clear();
            this.recordCache = null;
        }
        super.close(ctx);
    }

    protected void validate(ExecutionContext ctx) {
        if (this.validatorAction == null) {
            throw new IllegalStateException("FileValidatorAction was not set. an Object that implements the validation logic must be set.");
        }
        try {
            Handler validateHandler;
            if (this.validatorAction instanceof Handler) {
                validateHandler = (Handler)this.validatorAction;
            } else {
                MethodBinder binding = ctx.getMethodBinder();
                if (binding == null) {
                    throw new RuntimeException("MethodBinder was not found. you must set a MethodBinder to the ExecutionHandler or make validator object implement Handler.");
                }
                validateHandler = binding.bind((Object)this.validatorAction);
            }
            if (this.useCache) {
                this.recordCache = new LinkedList<DataRecord>();
            }
            while (super.hasNext(ctx)) {
                DataRecord record = super.read(ctx);
                validateHandler.handle((Object)record, ctx);
                if (!this.useCache) continue;
                this.recordCache.add(record);
            }
            this.validatorAction.onFileEnd(ctx);
            super.close(ctx);
            if (!this.useCache) {
                this.initialize();
            }
        }
        catch (RuntimeException e) {
            try {
                this.close(ctx);
            }
            catch (Throwable t) {
                LOGGER.logWarn("failed to release file resource.", t, new Object[0]);
            }
            throw e;
        }
        catch (Error e) {
            try {
                this.close(ctx);
            }
            catch (Throwable t) {
                LOGGER.logWarn("failed to release file resource.", t, new Object[0]);
            }
            throw e;
        }
        finally {
            this.validated = true;
        }
    }

    protected void initialize() {
        this.getFileReader().close();
        this.setFileReader(null);
    }

    @Published(tag={"architect"})
    public synchronized ValidatableFileDataReader setUseCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    @Published(tag={"architect"})
    public ValidatableFileDataReader setValidatorAction(FileValidatorAction validatorAction) {
        if (validatorAction == null) {
            throw new IllegalArgumentException("validator action was null. validator action must not be null.");
        }
        this.validatorAction = validatorAction;
        return this;
    }

    @Published
    public static interface FileValidatorAction {
        public void onFileEnd(ExecutionContext var1);
    }
}

