/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.jaxrs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.StringUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.jaxrs.BodyConverter;
import nablarch.fw.jaxrs.EntityResponse;
import nablarch.fw.jaxrs.JaxRsContext;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;

public class BodyConvertHandler
implements HttpRequestHandler {
    private static final Logger LOGGER = LoggerManager.get(BodyConvertHandler.class);
    private List<BodyConverter> bodyConverters = new ArrayList<BodyConverter>();

    public HttpResponse handle(HttpRequest request, ExecutionContext context) {
        String entityResponseContentType;
        Object response;
        String consumesMediaType;
        JaxRsContext jaxRsContext = JaxRsContext.get(context);
        String contentType = request.getHeader("Content-Type");
        if (!this.supportsMediaType(contentType, consumesMediaType = jaxRsContext.getConsumesMediaType())) {
            LOGGER.logInfo("unsupported media type requested. request method = [" + request.getMethod() + "], request uri = [" + request.getRequestUri() + "], content type = [" + contentType + "], resource method = [" + jaxRsContext.toResourcePath() + "], consumes media type = [" + consumesMediaType + "]", new Object[0]);
            throw new HttpErrorResponse(HttpResponse.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        }
        if (StringUtil.hasValue((String)consumesMediaType)) {
            jaxRsContext.setRequest(this.findConverter(consumesMediaType).read(request, context));
        }
        if ((response = context.handleNext((Object)request)) == null) {
            return new HttpResponse(HttpResponse.Status.NO_CONTENT.getStatusCode());
        }
        EntityResponse entityResponse = response instanceof EntityResponse ? (EntityResponse)((Object)response) : null;
        Object entity = entityResponse != null ? entityResponse.getEntity() : response;
        String producesMediaType = jaxRsContext.getProducesMediaType();
        String string = entityResponseContentType = entityResponse != null ? entityResponse.getHeader("Content-Type") : null;
        if (StringUtil.hasValue((String)entityResponseContentType)) {
            if (StringUtil.hasValue((String)producesMediaType)) {
                throw new IllegalStateException("Content-Type is specified in both @Produces and EntityResponse. Specify the Content-Type in either @Produces or EntityResponse. resource method = [" + jaxRsContext.toResourcePath() + "]");
            }
            producesMediaType = entityResponseContentType;
        }
        if (StringUtil.hasValue((String)producesMediaType)) {
            HttpResponse convertedResponse = this.findConverter(producesMediaType).write(entity, context);
            if (entityResponse != null) {
                this.copy(entityResponse, convertedResponse);
            }
            return convertedResponse;
        }
        return this.cast(response);
    }

    private void copy(EntityResponse from, HttpResponse to) {
        Map toHeaderMap = to.getHeaderMap();
        for (Map.Entry fromHeader : from.getHeaderMap().entrySet()) {
            if (toHeaderMap.containsKey(fromHeader.getKey())) continue;
            toHeaderMap.put(fromHeader.getKey(), fromHeader.getValue());
        }
        if (from.isStatusCodeSet()) {
            to.setStatusCode(from.getStatusCode());
        }
    }

    private BodyConverter findConverter(String mediaType) {
        for (BodyConverter converter : this.bodyConverters) {
            if (!converter.isConvertible(mediaType)) continue;
            return converter;
        }
        throw new HttpErrorResponse(HttpResponse.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
    }

    private HttpResponse cast(Object response) {
        if (response != null && !(response instanceof HttpResponse)) {
            throw new IllegalStateException(String.format("unsupported response type found. must be return %s. response type = [%s]", HttpResponse.class.getName(), response.getClass().getName()));
        }
        return (HttpResponse)response;
    }

    protected boolean supportsMediaType(String contentType, String consumesMediaType) {
        if (StringUtil.hasValue((String)contentType)) {
            return consumesMediaType != null && contentType.toLowerCase().contains(consumesMediaType);
        }
        return StringUtil.isNullOrEmpty((String)consumesMediaType);
    }

    public void setBodyConverters(List<BodyConverter> bodyConverters) {
        this.bodyConverters = Collections.unmodifiableList(bodyConverters);
    }

    public void addBodyConverter(BodyConverter bodyConverter) {
        this.bodyConverters.add(bodyConverter);
    }
}

