/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.jaxrs;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.jaxrs.BodyConverter;
import nablarch.fw.jaxrs.JaxRsContext;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.servlet.NablarchHttpServletRequestWrapper;
import nablarch.fw.web.servlet.ServletExecutionContext;

@Published(tag={"architect"})
public abstract class BodyConverterSupport
implements BodyConverter {
    private static final Logger LOGGER = LoggerManager.get(BodyConverterSupport.class);
    private static final Pattern CHARSET_PATTERN = Pattern.compile("^.*?;\\s*charset=\\s*\"?(.*?)\"?\\s*$(;.*)?");
    private Charset defaultEncoding = Charset.forName("UTF-8");

    public void setDefaultEncoding(String name) {
        this.defaultEncoding = Charset.forName(name);
    }

    @Override
    public Object read(HttpRequest request, ExecutionContext executionContext) {
        JaxRsContext jaxRsContext = JaxRsContext.get(executionContext);
        Class<?> beanClass = jaxRsContext.getRequestClass();
        if (beanClass == null) {
            throw new IllegalArgumentException("consumes media type and resource method signature is mismatch.");
        }
        NablarchHttpServletRequestWrapper servletRequest = ((ServletExecutionContext)executionContext).getServletRequest();
        if (StringUtil.hasValue((String)servletRequest.getCharacterEncoding())) {
            BodyConverterSupport.validateEncoding(servletRequest.getCharacterEncoding());
        } else {
            this.changeRequestEncoding((ServletRequest)servletRequest);
        }
        return this.convertRequest(request, executionContext);
    }

    protected abstract Object convertRequest(HttpRequest var1, ExecutionContext var2);

    @Override
    public HttpResponse write(Object response, ExecutionContext executionContext) {
        if (response instanceof HttpResponse) {
            throw new IllegalArgumentException("produces media type and resource method signature is mismatch.");
        }
        return this.convertResponse(response, executionContext);
    }

    protected abstract HttpResponse convertResponse(Object var1, ExecutionContext var2);

    private void changeRequestEncoding(ServletRequest servletRequest) {
        try {
            servletRequest.setCharacterEncoding(this.defaultEncoding.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private static void validateEncoding(String encoding) {
        try {
            Charset.forName(encoding);
        }
        catch (RuntimeException e) {
            LOGGER.logInfo("consumes charset is invalid. charset = [" + encoding + ']', new Object[0]);
            throw new HttpErrorResponse(400, (Throwable)e);
        }
    }

    protected ContentType getContentType(String mediaType) {
        Matcher matcher = CHARSET_PATTERN.matcher(mediaType);
        if (matcher.matches()) {
            try {
                return new ContentType(mediaType, Charset.forName(matcher.group(1)));
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("produces charset is invalid. charset = [" + matcher.group(1) + ']', e);
            }
        }
        return new ContentType(mediaType + ";charset=" + this.defaultEncoding.name(), this.defaultEncoding);
    }

    public static final class ContentType {
        private final String value;
        private final Charset encoding;

        public ContentType(String value, Charset encoding) {
            this.value = value;
            this.encoding = encoding;
        }

        public String getValue() {
            return this.value;
        }

        public Charset getEncoding() {
            return this.encoding;
        }
    }
}

