/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.jaxrs;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import nablarch.core.beans.BeanUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.jaxrs.BodyConverterSupport;
import nablarch.fw.jaxrs.JaxRsContext;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;

public class FormUrlEncodedConverter
extends BodyConverterSupport {
    @Override
    protected Object convertRequest(HttpRequest request, ExecutionContext context) {
        JaxRsContext jaxRsContext = JaxRsContext.get(context);
        return BeanUtil.createAndCopy(jaxRsContext.getRequestClass(), (Map)request.getParamMap());
    }

    @Override
    protected HttpResponse convertResponse(Object response, ExecutionContext context) {
        JaxRsContext jaxRsContext = JaxRsContext.get(context);
        MultivaluedMap<String, String> multivaluedMap = this.castResponse(response, jaxRsContext);
        if (multivaluedMap.isEmpty()) {
            return new HttpResponse(HttpResponse.Status.NO_CONTENT.getStatusCode());
        }
        BodyConverterSupport.ContentType contentType = this.getContentType(jaxRsContext.getProducesMediaType());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : multivaluedMap.entrySet()) {
            String key = this.encode((String)entry.getKey(), contentType.getEncoding());
            for (String value : (List)entry.getValue()) {
                if (sb.length() != 0) {
                    sb.append('&');
                }
                sb.append(key).append('=');
                if (value == null) continue;
                sb.append(this.encode(value, contentType.getEncoding()));
            }
        }
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setContentType(contentType.getValue());
        httpResponse.write((CharSequence)sb);
        return httpResponse;
    }

    private String encode(String str, Charset encoding) {
        try {
            return URLEncoder.encode(str, encoding.name());
        }
        catch (UnsupportedEncodingException ignore) {
            throw new RuntimeException(ignore);
        }
    }

    private MultivaluedMap<String, String> castResponse(Object response, JaxRsContext context) {
        try {
            return (MultivaluedMap)response;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(String.format("return type of resource method that specified @Produces({ \"application/x-www-form-urlencoded\" }) should be MultivaluedMap<String, String>. resource class = [%s], resource method = [%s], return type = [%s]", context.getResourceMethod().getDeclaringClass().getSimpleName(), context.getResourceMethod().getName(), response.getClass().getSimpleName()), e);
        }
    }

    @Override
    public boolean isConvertible(String mediaType) {
        return mediaType.toLowerCase().startsWith("application/x-www-form-urlencoded");
    }
}

