/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.jaxrs;

import java.lang.reflect.Method;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import nablarch.core.util.StringUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.web.HttpRequest;

public class JaxRsContext {
    private static final String CONTEXT_KEY = "nablarch_" + JaxRsContext.class.getSimpleName();
    private final Method resourceMethod;
    private Object request;

    public static JaxRsContext get(ExecutionContext context) {
        return (JaxRsContext)context.getRequestScopedVar(CONTEXT_KEY);
    }

    public static void set(ExecutionContext context, JaxRsContext jaxRsContext) {
        context.setRequestScopedVar(CONTEXT_KEY, (Object)jaxRsContext);
    }

    public JaxRsContext(Method resourceMethod) {
        this.resourceMethod = resourceMethod;
    }

    public Method getResourceMethod() {
        return this.resourceMethod;
    }

    public <T> T getRequest() {
        return (T)this.request;
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public void setRequest(Object request) {
        this.request = request;
    }

    public boolean hasValidAnnotation() {
        return this.resourceMethod.getAnnotation(Valid.class) != null;
    }

    public String getConsumesMediaType() {
        Consumes consumes = this.resourceMethod.getAnnotation(Consumes.class);
        if (consumes == null) {
            return null;
        }
        return StringUtil.hasValue((String[])consumes.value()) ? consumes.value()[0] : null;
    }

    public String getProducesMediaType() {
        Produces produces = this.resourceMethod.getAnnotation(Produces.class);
        if (produces == null) {
            return null;
        }
        return StringUtil.hasValue((String[])produces.value()) ? produces.value()[0] : null;
    }

    public Class<?> getRequestClass() {
        for (Class<?> paramType : this.resourceMethod.getParameterTypes()) {
            if (paramType.equals(HttpRequest.class) || paramType.equals(ExecutionContext.class)) continue;
            return paramType;
        }
        return null;
    }

    public String toResourcePath() {
        Class<?> resourceClass = this.resourceMethod.getDeclaringClass();
        return resourceClass.getName() + '#' + this.resourceMethod.getName();
    }
}

