/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.HandlerWrapper;
import nablarch.fw.Interceptor;
import nablarch.fw.MethodBinder;
import nablarch.fw.handler.MethodBinding;
import nablarch.fw.jaxrs.JaxRsContext;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;

public class JaxRsMethodBinder
implements MethodBinder<HttpRequest, Object> {
    private final String methodName;
    private final List<Handler<HttpRequest, ?>> handlerList;

    public JaxRsMethodBinder(String methodName, List<Handler<HttpRequest, ?>> handlerList) {
        this.methodName = methodName;
        this.handlerList = handlerList;
    }

    public HandlerWrapper<HttpRequest, Object> bind(Object delegate) {
        return new JaxrsMethodBinding(delegate, this.methodName, this.handlerList);
    }

    private static class JaxrsMethodBinding
    extends MethodBinding<HttpRequest, Object> {
        private final Object delegate;
        private final String methodName;
        private final List<Handler<HttpRequest, ?>> handlerList;

        public JaxrsMethodBinding(Object delegate, String methodName, List<Handler<HttpRequest, ?>> handlerList) {
            super(delegate);
            this.delegate = delegate;
            this.methodName = methodName;
            this.handlerList = handlerList;
        }

        protected Method getMethodBoundTo(HttpRequest httpRequest, ExecutionContext executionContext) {
            Method method = null;
            for (Method m : this.delegate.getClass().getMethods()) {
                if (!m.getName().equals(this.methodName)) continue;
                if (method != null) {
                    throw new IllegalArgumentException("method name is duplicated. class = [" + this.delegate.getClass().getName() + "], method = [" + this.methodName + ']');
                }
                method = m;
            }
            return method;
        }

        public HttpResponse handle(HttpRequest req, ExecutionContext ctx) {
            Method boundMethod = this.getMethodBoundTo(req, ctx);
            if (boundMethod == null) {
                throw new HttpErrorResponse(HttpResponse.Status.NOT_FOUND.getStatusCode());
            }
            final ResourceMethod resourceMethod = new ResourceMethod(boundMethod);
            Handler<HttpRequest, Object> handler = new Handler<HttpRequest, Object>(){

                public Object handle(HttpRequest req, ExecutionContext ctx) {
                    return resourceMethod.invoke(JaxrsMethodBinding.this.delegate, req, ctx);
                }
            };
            JaxRsContext.set(ctx, new JaxRsContext(boundMethod));
            if (this.handlerList != null && !this.handlerList.isEmpty()) {
                ctx.addHandlers(this.handlerList);
            }
            Handler wrappedHandler = Interceptor.Factory.wrap((Handler)handler, (Annotation[])boundMethod.getAnnotations());
            return (HttpResponse)((ExecutionContext)ctx.addHandler(wrappedHandler)).handleNext((Object)req);
        }
    }

    public static class ResourceMethod {
        private final Method method;
        private final List<ParameterType> parameterTypes;

        public ResourceMethod(Method method) {
            this.parameterTypes = this.createParameterTypeList(method);
            this.method = method;
        }

        public Object invoke(Object resourceClass, HttpRequest request, ExecutionContext context) {
            try {
                return this.method.invoke(resourceClass, this.createParameter(request, context));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        private List<ParameterType> createParameterTypeList(Method resourceMethod) {
            ArrayList<ParameterType> result = new ArrayList<ParameterType>(3);
            for (Class<?> type : resourceMethod.getParameterTypes()) {
                ParameterType parameterType = type.equals(HttpRequest.class) ? ParameterType.HTTP_REQUEST : (type.equals(ExecutionContext.class) ? ParameterType.CONTEXT : ParameterType.BEAN);
                if (result.contains((Object)parameterType)) {
                    throw new IllegalArgumentException("argument definition is invalid. method = [" + resourceMethod.getName() + ']');
                }
                result.add(parameterType);
            }
            return result;
        }

        private Object[] createParameter(HttpRequest request, ExecutionContext context) {
            ArrayList<Object> params = new ArrayList<Object>();
            for (ParameterType paramType : this.parameterTypes) {
                if (paramType == ParameterType.HTTP_REQUEST) {
                    params.add(request);
                    continue;
                }
                if (paramType == ParameterType.CONTEXT) {
                    params.add(context);
                    continue;
                }
                JaxRsContext jaxRsContext = JaxRsContext.get(context);
                params.add(jaxRsContext.getRequest());
            }
            return params.toArray();
        }

        private static enum ParameterType {
            HTTP_REQUEST,
            CONTEXT,
            BEAN;

        }
    }
}

