/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.jaxrs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.FileUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.jaxrs.ErrorResponseBuilder;
import nablarch.fw.jaxrs.JaxRsErrorLogWriter;
import nablarch.fw.jaxrs.ResponseFinisher;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpRequestHandler;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class JaxRsResponseHandler
implements HttpRequestHandler {
    private static final int BUFFER_SIZE = 4096;
    private ErrorResponseBuilder errorResponseBuilder = new ErrorResponseBuilder();
    private JaxRsErrorLogWriter errorLogWriter = new JaxRsErrorLogWriter();
    private List<ResponseFinisher> responseFinishers = Collections.emptyList();
    private static final Logger LOGGER = LoggerManager.get(JaxRsResponseHandler.class);
    private boolean setContentTypeForResponseWithNoBody = false;

    public HttpResponse handle(HttpRequest request, ExecutionContext context) {
        HttpResponse response;
        try {
            response = (HttpResponse)context.handleNext((Object)request);
        }
        catch (HttpErrorResponse errorResponse) {
            response = errorResponse.getResponse();
        }
        catch (Throwable e) {
            try {
                response = this.errorResponseBuilder.build(request, context, e);
            }
            catch (Throwable responseBuilderException) {
                response = new HttpResponse(500);
                LOGGER.logWarn("An exception was thrown while processing ErrorResponseBuilder. class=[" + this.errorResponseBuilder.getClass().getName() + "]", responseBuilderException, new Object[0]);
            }
            this.errorLogWriter.write(request, response, context, e);
        }
        this.finishResponse(request, response, context);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug(request.getMethod() + ' ' + request.getRequestUri() + " status code=[" + response.getStatusCode() + "], content length=[" + response.getContentLength() + ']', new Object[0]);
        }
        this.writeResponse(response, (ServletExecutionContext)context);
        return response;
    }

    protected void finishResponse(HttpRequest request, HttpResponse response, ExecutionContext context) {
        for (ResponseFinisher responseFinisher : this.responseFinishers) {
            responseFinisher.finish(request, response, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResponse(HttpResponse response, ServletExecutionContext context) {
        HttpServletResponse nativeResponse = context.getServletResponse();
        this.writeHeaders(response, nativeResponse);
        InputStream inputStream = response.getBodyStream();
        if (inputStream != null) {
            try {
                JaxRsResponseHandler.writeBody(inputStream, context.getServletResponse());
            }
            catch (IOException e) {
                LOGGER.logWarn("failed to write response.", (Throwable)e, new Object[0]);
            }
            finally {
                response.cleanup();
            }
        }
    }

    protected void writeHeaders(HttpResponse response, HttpServletResponse nativeResponse) {
        nativeResponse.setStatus(response.getStatusCode());
        if (response.getContentLength() != null) {
            nativeResponse.setContentLength(Integer.parseInt(response.getContentLength()));
        }
        if (this.setContentTypeForResponseWithNoBody) {
            nativeResponse.setContentType(response.getContentType());
        } else {
            String contentType = response.getHeader("Content-Type");
            if (contentType != null) {
                nativeResponse.setContentType(contentType);
            }
        }
        for (Map.Entry entry : response.getHeaderMap().entrySet()) {
            if (((String)entry.getKey()).equals("Content-Length") || ((String)entry.getKey()).equals("Content-Type")) continue;
            nativeResponse.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeBody(InputStream in, HttpServletResponse nativeRes) throws IOException {
        ServletOutputStream out = nativeRes.getOutputStream();
        try {
            byte[] bytes;
            int readBytes;
            while ((readBytes = in.read(bytes = new byte[4096])) != -1) {
                out.write(bytes, 0, readBytes);
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly((Closeable[])new Closeable[]{in});
            FileUtil.closeQuietly((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{in});
        FileUtil.closeQuietly((Closeable[])new Closeable[]{out});
    }

    public void setErrorResponseBuilder(ErrorResponseBuilder errorResponseBuilder) {
        this.errorResponseBuilder = errorResponseBuilder;
    }

    public void setErrorLogWriter(JaxRsErrorLogWriter errorLogWriter) {
        this.errorLogWriter = errorLogWriter;
    }

    public void setResponseFinishers(List<ResponseFinisher> responseFinishers) {
        this.responseFinishers = responseFinishers;
    }

    public void setSetContentTypeForResponseWithNoBody(boolean setContentTypeForResponseWithNoBody) {
        this.setContentTypeForResponseWithNoBody = setContentTypeForResponseWithNoBody;
    }
}

