/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.jaxrs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.annotation.Published;
import nablarch.fw.ExecutionContext;
import nablarch.fw.jaxrs.BodyConverterSupport;
import nablarch.fw.jaxrs.JaxRsContext;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.servlet.NablarchHttpServletRequestWrapper;
import nablarch.fw.web.servlet.ServletExecutionContext;

@Published(tag={"architect"})
public class JaxbBodyConverter
extends BodyConverterSupport {
    private static final Logger LOGGER = LoggerManager.get(JaxbBodyConverter.class);
    private static final Map<Class<?>, JAXBContext> JAXB_CONTEXT_MAP = new ConcurrentHashMap();

    @Override
    protected Object convertRequest(HttpRequest request, ExecutionContext context) {
        Unmarshaller unmarshaller;
        JaxRsContext jaxRsContext = JaxRsContext.get(context);
        Class<?> beanClass = jaxRsContext.getRequestClass();
        NablarchHttpServletRequestWrapper servletRequest = ((ServletExecutionContext)context).getServletRequest();
        try {
            unmarshaller = this.getJAXBContext(beanClass).createUnmarshaller();
            this.configure(unmarshaller);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("failed to configure Unmarshaller.", e);
        }
        try {
            return unmarshaller.unmarshal((Source)new StreamSource(servletRequest.getReader()), beanClass).getValue();
        }
        catch (JAXBException e) {
            LOGGER.logInfo("failed to read request. cause = [" + e.getMessage() + ']', new Object[0]);
            throw new HttpErrorResponse(HttpResponse.Status.BAD_REQUEST.getStatusCode(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.logInfo("failed to read request. cause = [" + e.getMessage() + ']', new Object[0]);
            throw new HttpErrorResponse(HttpResponse.Status.BAD_REQUEST.getStatusCode(), (Throwable)e);
        }
    }

    @Override
    protected HttpResponse convertResponse(Object response, ExecutionContext context) {
        Marshaller marshaller;
        JaxRsContext jaxRsContext = JaxRsContext.get(context);
        HttpResponse httpResponse = new HttpResponse();
        BodyConverterSupport.ContentType contentType = this.getContentType(jaxRsContext.getProducesMediaType());
        httpResponse.setContentType(contentType.getValue());
        try {
            marshaller = this.getJAXBContext(response.getClass()).createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)contentType.getEncoding().name());
            this.configure(marshaller);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("failed to configure Marshaller.", e);
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            marshaller.marshal(response, (OutputStream)os);
            httpResponse.write(os.toByteArray());
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("failed to write response.", e);
        }
        return httpResponse;
    }

    @Override
    public boolean isConvertible(String mediaType) {
        return mediaType.toLowerCase().startsWith("application/xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getJAXBContext(Class<?> beanClass) throws JAXBException {
        if (JAXB_CONTEXT_MAP.containsKey(beanClass)) {
            return JAXB_CONTEXT_MAP.get(beanClass);
        }
        Map<Class<?>, JAXBContext> map = JAXB_CONTEXT_MAP;
        synchronized (map) {
            if (JAXB_CONTEXT_MAP.containsKey(beanClass)) {
                return JAXB_CONTEXT_MAP.get(beanClass);
            }
            JAXB_CONTEXT_MAP.put(beanClass, JAXBContext.newInstance((Class[])new Class[]{beanClass}));
            return JAXB_CONTEXT_MAP.get(beanClass);
        }
    }

    protected void configure(Marshaller marshaller) throws JAXBException {
    }

    protected void configure(Unmarshaller unmarshaller) throws JAXBException {
    }
}

