/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.jaxrs.cors;

import java.util.Arrays;
import java.util.List;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.StringUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.jaxrs.cors.Cors;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;

public class BasicCors
implements Cors {
    private static final Logger LOGGER = LoggerManager.get(Cors.class);
    private List<String> allowOrigins = null;
    private String allowMethods = BasicCors.joinWithComma(Arrays.asList("OPTIONS", "GET", "POST", "PUT", "DELETE", "PATCH"));
    private String allowHeaders = BasicCors.joinWithComma(Arrays.asList("Content-Type", "X-CSRF-TOKEN"));
    private long maxAge = -1L;
    private boolean allowCredentials = true;

    @Override
    public boolean isPreflightRequest(HttpRequest request, ExecutionContext context) {
        return request.getMethod().equals("OPTIONS") && request.getHeader("Origin") != null && request.getHeader("Access-Control-Request-Method") != null && request.getHeader("Access-Control-Request-Headers") != null;
    }

    @Override
    public HttpResponse createPreflightResponse(HttpRequest request, ExecutionContext context) {
        if (LOGGER.isDebugEnabled()) {
            String message = String.format("Preflight request%nRequest-Path: %s%n%s: %s%n%s: %s%n%s: %s", request.getRequestPath(), "Origin", request.getHeader("Origin"), "Access-Control-Request-Method", request.getHeader("Access-Control-Request-Method"), "Access-Control-Request-Headers", request.getHeader("Access-Control-Request-Headers"));
            LOGGER.logDebug(message, new Object[0]);
        }
        HttpResponse response = new HttpResponse(204);
        response.setHeader("Access-Control-Allow-Methods", this.allowMethods);
        response.setHeader("Access-Control-Allow-Headers", this.allowHeaders);
        response.setHeader("Access-Control-Max-Age", String.valueOf(this.maxAge));
        this.postProcess(request, response, context);
        return response;
    }

    @Override
    public void postProcess(HttpRequest request, HttpResponse response, ExecutionContext context) {
        this.processOrigin(request, response);
        this.processCredentials(response);
    }

    private void processOrigin(HttpRequest request, HttpResponse response) {
        if (this.allowOrigins == null) {
            throw new IllegalStateException("The allowOrigins property of CORS must be set.");
        }
        String origin = request.getHeader("Origin");
        if (this.allowOrigins.contains(origin)) {
            response.setHeader("Access-Control-Allow-Origin", origin);
            response.setHeader("Vary", "Origin");
        }
    }

    private void processCredentials(HttpResponse response) {
        if (this.allowCredentials) {
            response.setHeader("Access-Control-Allow-Credentials", "true");
        }
    }

    private static String joinWithComma(List<String> collection) {
        return StringUtil.join((String)", ", collection);
    }

    public void setAllowOrigins(List<String> allowOrigins) {
        this.allowOrigins = allowOrigins;
    }

    public void setAllowMethods(List<String> allowMethods) {
        this.allowMethods = BasicCors.joinWithComma(allowMethods);
    }

    public void setAllowHeaders(List<String> allowHeaders) {
        this.allowHeaders = BasicCors.joinWithComma(allowHeaders);
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    private static final class Headers {
        static final String ORIGIN = "Origin";
        static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
        static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
        static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
        static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
        static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
        static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
        static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
        static final String VARY = "Vary";

        private Headers() {
        }
    }
}

