/*
 * Decompiled with CFR 0.152.
 */
package nablarch.core.dataformat;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import nablarch.core.dataformat.DataRecord;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.DataRecordFormatterSupport;
import nablarch.core.dataformat.FormatterFactory;
import nablarch.core.dataformat.InvalidDataFormatException;
import nablarch.core.dataformat.SimpleDataConvertResult;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.FilePathSetting;

public final class SimpleDataConvertUtil {
    private static final Logger LOGGER = LoggerManager.get(SimpleDataConvertUtil.class);

    private SimpleDataConvertUtil() {
    }

    public static SimpleDataConvertResult buildData(String formatName, Map<String, ?> data) throws InvalidDataFormatException {
        DataRecordFormatter formatter = SimpleDataConvertUtil.getFormatter(formatName);
        Charset charset = SimpleDataConvertUtil.getCharset(formatter);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            return SimpleDataConvertUtil.buildData(formatName, data, baos).setResultText(new String(baos.toByteArray(), charset));
        }
        catch (IOException wontHappen) {
            throw new RuntimeException(wontHappen);
        }
    }

    public static SimpleDataConvertResult buildData(String formatName, Map<String, ?> data, OutputStream out) throws InvalidDataFormatException, IOException {
        DataRecordFormatter formatter = SimpleDataConvertUtil.getFormatter(formatName);
        formatter.setOutputStream(out);
        formatter.initialize();
        formatter.writeRecord(data);
        formatter.close();
        return SimpleDataConvertUtil.createResult(formatter);
    }

    public static SimpleDataConvertResult parseData(String formatName, String data) throws InvalidDataFormatException {
        DataRecordFormatter formatter = SimpleDataConvertUtil.getFormatter(formatName);
        Charset charset = SimpleDataConvertUtil.getCharset(formatter);
        try {
            return SimpleDataConvertUtil.parseData(formatName, new ByteArrayInputStream(data.getBytes(charset)));
        }
        catch (IOException wontHappen) {
            throw new RuntimeException(wontHappen);
        }
    }

    public static SimpleDataConvertResult parseData(String formatName, InputStream in) throws InvalidDataFormatException, IOException {
        DataRecordFormatter formatter = SimpleDataConvertUtil.getFormatter(formatName);
        formatter.setInputStream(in);
        formatter.initialize();
        DataRecord resultMap = formatter.readRecord();
        formatter.close();
        return SimpleDataConvertUtil.createResult(formatter).setResultMap((Map<String, ?>)resultMap);
    }

    private static DataRecordFormatter getFormatter(String formatName) {
        File formatFile = FilePathSetting.getInstance().getFileWithoutCreate("format", formatName);
        DataRecordFormatter formatter = FormatterFactory.getInstance().createFormatter(formatFile);
        formatter.initialize();
        return formatter;
    }

    private static SimpleDataConvertResult createResult(DataRecordFormatter formatter) {
        SimpleDataConvertResult result = new SimpleDataConvertResult();
        if (formatter instanceof DataRecordFormatterSupport) {
            DataRecordFormatterSupport drfs = (DataRecordFormatterSupport)formatter;
            result.setCharset(drfs.getDefaultEncoding());
            result.setDataType(drfs.getFileType());
            result.setMimeType(drfs.getMimeType());
        }
        return result;
    }

    private static Charset getCharset(DataRecordFormatter formatter) {
        Charset charset = Charset.defaultCharset();
        if (formatter instanceof DataRecordFormatterSupport) {
            charset = ((DataRecordFormatterSupport)formatter).getDefaultEncoding();
        }
        return charset;
    }
}

