/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.handler;

import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.log.app.FailureLogUtil;
import nablarch.core.message.ApplicationException;
import nablarch.core.util.Builder;
import nablarch.fw.ExecutionContext;
import nablarch.fw.NoMoreHandlerException;
import nablarch.fw.Result;
import nablarch.fw.messaging.MessagingException;
import nablarch.fw.results.ServiceError;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.handler.HttpErrorHandler;

public class HttpMessagingErrorHandler
extends HttpErrorHandler {
    private static final Logger LOGGER = LoggerManager.get(HttpMessagingErrorHandler.class);

    public HttpResponse handle(HttpRequest req, ExecutionContext ctx) {
        req.getHeaderMap().put("X-Requested-With", "XMLHttpRequest");
        HttpResponse res = null;
        try {
            res = (HttpResponse)ctx.handleNext((Object)req);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("HTTP Response: ", new Object[]{res, res.getContentPath()});
            }
        }
        catch (HttpErrorResponse e) {
            ctx.setException(e.getCause());
            Throwable cause = e.getCause();
            if (cause != null) {
                this.handleError(e.getCause(), req, ctx);
            }
            res = e.getResponse();
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable e) {
            res = this.handleError(e, req, ctx);
        }
        if (res.isBodyEmpty()) {
            res.setContentPath(this.getDefaultPageFor(res.getStatusCode()));
        }
        return res;
    }

    protected HttpResponse handleError(Throwable e, HttpRequest req, ExecutionContext ctx) {
        if (e instanceof NoMoreHandlerException) {
            LOGGER.logInfo(Builder.concat((Object[])new Object[]{"There were no Handlers in handlerQueue.", " uri = [", req.getRequestUri(), "]"}), new Object[0]);
            return HttpResponse.Status.NOT_FOUND.handle(req, ctx);
        }
        if (e instanceof Result.Error) {
            Result.Error err = (Result.Error)e;
            if (this.writeFailureLogPattern.matcher(String.valueOf(err.getStatusCode())).matches()) {
                if (err instanceof ServiceError) {
                    ((ServiceError)err).writeLog(ctx);
                } else {
                    FailureLogUtil.logFatal((Throwable)err, (Object)ctx.getDataProcessedWhenThrown((Throwable)err), null, (Object[])new Object[0]);
                }
            }
            ctx.setException(err.getCause());
            return new HttpResponse(err.getStatusCode());
        }
        if (e instanceof MessagingException || e instanceof ApplicationException) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("Error due to an invalid request message: ", e, new Object[0]);
            }
            return new HttpErrorResponse(400, e).getResponse();
        }
        if (e instanceof RuntimeException) {
            FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown(e), null, (Object[])new Object[0]);
            ctx.setException(e);
            return HttpResponse.Status.INTERNAL_SERVER_ERROR.handle(req, ctx);
        }
        if (e instanceof StackOverflowError) {
            FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown(e), null, (Object[])new Object[0]);
            ctx.setException(e);
            return HttpResponse.Status.INTERNAL_SERVER_ERROR.handle(req, ctx);
        }
        FailureLogUtil.logFatal((Throwable)e, (Object)ctx.getDataProcessedWhenThrown(e), null, (Object[])new Object[0]);
        ctx.setException(e);
        return HttpResponse.Status.INTERNAL_SERVER_ERROR.handle(req, ctx);
    }
}

