/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.handler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import nablarch.core.ThreadContext;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.FormatterFactory;
import nablarch.core.dataformat.InvalidDataFormatException;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.FilePathSetting;
import nablarch.core.util.StringUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.messaging.FwHeader;
import nablarch.fw.messaging.FwHeaderDefinition;
import nablarch.fw.messaging.InterSystemMessage;
import nablarch.fw.messaging.MessagingException;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.RequestMessage;
import nablarch.fw.messaging.SendingMessage;
import nablarch.fw.messaging.logging.MessagingLogUtil;
import nablarch.fw.messaging.reader.StructuredFwHeaderDefinition;
import nablarch.fw.results.RequestEntityTooLarge;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpRequest;
import nablarch.fw.web.HttpResponse;
import nablarch.fw.web.servlet.HttpRequestWrapper;
import nablarch.fw.web.servlet.ServletExecutionContext;

public class HttpMessagingRequestParsingHandler
implements Handler<HttpRequest, Object> {
    private static final Logger LOGGER = LoggerManager.get(HttpMessagingRequestParsingHandler.class);
    private static final Logger MESSAGING_LOGGER = LoggerManager.get((String)"MESSAGING");
    private static final Pattern CHARSET_PTN = Pattern.compile(".*charset=(.+)");
    private static final String HTTP_HEADER_MESSAGE_ID = "X-Message-Id";
    private static final String HTTP_HEADER_CORRELATION_ID = "X-Correlation-Id";
    private FwHeaderDefinition fwHeaderDefinition = new StructuredFwHeaderDefinition();
    private static final String FORMAT_FILE_DIR = "format";
    private static final int BODY_READ_BUF_SIZE = 4096;
    private int bodyLengthLimit = Integer.MAX_VALUE;

    public Object handle(HttpRequest req, ExecutionContext ctx) throws ClassCastException {
        RequestMessage requestMessage;
        ServletExecutionContext servletContext = (ServletExecutionContext)ctx;
        String messageId = req.getHeader(HTTP_HEADER_MESSAGE_ID);
        if (StringUtil.isNullOrEmpty((String)messageId)) {
            LOGGER.logInfo("Request of empty messageId received.", new Object[0]);
            return HttpResponse.Status.BAD_REQUEST.handle(req, ctx);
        }
        try {
            requestMessage = this.createRequestMessage(req, servletContext, messageId);
        }
        catch (RequestEntityTooLarge e) {
            LOGGER.logInfo("request entity too large.: " + e.getMessage(), new Object[0]);
            return new HttpErrorResponse(413, (Throwable)e).getResponse();
        }
        catch (MessagingException e) {
            LOGGER.logInfo("invalid request message received.: " + e.getMessage(), new Object[0]);
            return HttpResponse.Status.BAD_REQUEST.handle(req, ctx);
        }
        catch (InvalidDataFormatException e) {
            LOGGER.logInfo("invalid format request message received.: " + e.getMessage(), new Object[0]);
            return HttpResponse.Status.BAD_REQUEST.handle(req, ctx);
        }
        return ctx.handleNext((Object)requestMessage);
    }

    private RequestMessage createRequestMessage(HttpRequest request, ServletExecutionContext context, String messageId) {
        RequestMessage requestMessage;
        FwHeader header;
        ReceivedMessage receivedMessage = this.read(context, messageId);
        if (MESSAGING_LOGGER.isInfoEnabled()) {
            this.emitLog((InterSystemMessage<?>)receivedMessage, this.getCharsetFromContentType(request.getHeaderMap()));
        }
        if ((header = (requestMessage = this.fwHeaderDefinition.readFwHeaderFrom(receivedMessage)).getFwHeader()).hasUserId()) {
            ThreadContext.setUserId((String)header.getUserId());
        }
        String requestId = ThreadContext.getRequestId();
        requestMessage.setFormatter(this.createFormatter(requestId + "_RECEIVE"));
        requestMessage.setFormatterOfReply(this.createFormatter(requestId + "_SEND"));
        requestMessage.setRequestPath(requestId);
        String correlationId = request.getHeader(HTTP_HEADER_CORRELATION_ID);
        if (!StringUtil.isNullOrEmpty((String)correlationId)) {
            requestMessage.setCorrelationId(correlationId);
        }
        return requestMessage;
    }

    private ReceivedMessage read(ServletExecutionContext context, String messageId) {
        HttpRequestWrapper request = context.getHttpRequest();
        ReceivedMessage receivedMessage = new ReceivedMessage(this.readHttpBody(request));
        receivedMessage.setHeaderMap(request.getHeaderMap());
        receivedMessage.setReplyTo(request.getRequestPath());
        receivedMessage.setMessageId(messageId);
        return receivedMessage;
    }

    private byte[] readHttpBody(HttpRequestWrapper request) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ServletInputStream is = request.getInputStream();
        try {
            int len;
            int readCount = 0;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf, 0, buf.length)) > 0) {
                baos.write(buf, 0, len);
                if ((readCount += len) <= this.bodyLengthLimit) continue;
                throw new RequestEntityTooLarge();
            }
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
        return baos.toByteArray();
    }

    private DataRecordFormatter createFormatter(String formatFileName) {
        File file = FilePathSetting.getInstance().getFileIfExists(FORMAT_FILE_DIR, formatFileName);
        if (file == null) {
            return null;
        }
        return FormatterFactory.getInstance().createFormatter(file);
    }

    public void setFwHeaderDefinition(FwHeaderDefinition fwHeaderDefinition) {
        this.fwHeaderDefinition = fwHeaderDefinition;
    }

    private void emitLog(InterSystemMessage<?> message, Charset charset) {
        String log = message instanceof ReceivedMessage ? MessagingLogUtil.getHttpReceivedMessageLog((ReceivedMessage)((ReceivedMessage)message), (Charset)charset) : MessagingLogUtil.getHttpSentMessageLog((SendingMessage)((SendingMessage)message), (Charset)charset);
        MESSAGING_LOGGER.logInfo(log, new Object[0]);
    }

    private Charset getCharsetFromContentType(Map<String, String> headerMap) {
        String contentTypeHeader = StringUtil.nullToEmpty((String)headerMap.get("Content-Type"));
        Matcher matcher = CHARSET_PTN.matcher(contentTypeHeader);
        if (matcher.find()) {
            return Charset.forName(matcher.group(1));
        }
        return Charset.defaultCharset();
    }

    public int getBodyLengthLimit() {
        return this.bodyLengthLimit;
    }

    public void setBodyLengthLimit(int bodyLengthLimit) {
        if (bodyLengthLimit < 0) {
            throw new IllegalArgumentException("bodyLengthLimit must not be negative.");
        }
        this.bodyLengthLimit = bodyLengthLimit;
    }
}

