/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.handler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.DataRecordFormatterSupport;
import nablarch.core.dataformat.InvalidDataFormatException;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.StringUtil;
import nablarch.fw.ExecutionContext;
import nablarch.fw.Handler;
import nablarch.fw.messaging.ErrorResponseMessage;
import nablarch.fw.messaging.FwHeaderDefinition;
import nablarch.fw.messaging.InterSystemMessage;
import nablarch.fw.messaging.MessagingException;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.ResponseMessage;
import nablarch.fw.messaging.SendingMessage;
import nablarch.fw.messaging.logging.MessagingLogUtil;
import nablarch.fw.messaging.reader.StructuredFwHeaderDefinition;
import nablarch.fw.web.HttpErrorResponse;
import nablarch.fw.web.HttpResponse;

public class HttpMessagingResponseBuildingHandler
implements Handler<Object, Object> {
    private static final Logger LOGGER = LoggerManager.get(HttpMessagingResponseBuildingHandler.class);
    private static final Logger MESSAGING_LOGGER = LoggerManager.get((String)"MESSAGING");
    private static final String HTTP_HEADER_CORRELATION_ID = "X-Correlation-Id";
    private FwHeaderDefinition fwHeaderDefinition = new StructuredFwHeaderDefinition();

    public Object handle(Object req, ExecutionContext ctx) throws ClassCastException {
        try {
            Object res = ctx.handleNext(req);
            if (res instanceof ResponseMessage) {
                return this.createResponseMessage((ResponseMessage)res);
            }
            return res;
        }
        catch (MessagingException e) {
            LOGGER.logInfo("could not build the message body because of an invalid message error: " + e.getMessage(), new Object[0]);
            throw new HttpErrorResponse(500, (Throwable)e);
        }
        catch (InvalidDataFormatException e) {
            LOGGER.logInfo("could not build the message body because of an invalid data error: " + e.getMessage(), new Object[0]);
            throw new HttpErrorResponse(500, (Throwable)e);
        }
        catch (ErrorResponseMessage e) {
            HttpErrorResponse errorResponse = new HttpErrorResponse(e.getCause());
            errorResponse.setResponse(this.createResponseMessage(e.getResponse()));
            throw errorResponse;
        }
    }

    private HttpResponse createResponseMessage(ResponseMessage responseMessage) {
        HttpResponse httpResponse = new HttpResponse();
        DataRecordFormatter formatter = responseMessage.getFormatter();
        Charset charset = null;
        if (formatter instanceof DataRecordFormatterSupport) {
            DataRecordFormatterSupport drfs = (DataRecordFormatterSupport)formatter;
            String mimeType = drfs.getMimeType();
            charset = drfs.getDefaultEncoding();
            String contentType = String.format("%s;charset=%s", mimeType, charset.name());
            httpResponse.setContentType(contentType);
        }
        responseMessage.setFwHeaderDefinition(this.fwHeaderDefinition);
        httpResponse.setBodyStream((InputStream)new ByteArrayInputStream(responseMessage.getBodyBytes()));
        httpResponse.setStatusCode(this.getStatusCode(responseMessage));
        httpResponse.setHeader(HTTP_HEADER_CORRELATION_ID, (String)responseMessage.getHeader("CorrelationId"));
        if (MESSAGING_LOGGER.isInfoEnabled()) {
            this.emitLog((InterSystemMessage<?>)responseMessage, charset);
        }
        return httpResponse;
    }

    private int getStatusCode(ResponseMessage responseMessage) {
        String headerStatusCode = responseMessage.getFwHeader().getStatusCode();
        if (!StringUtil.isNullOrEmpty((String)headerStatusCode)) {
            return Integer.parseInt(headerStatusCode);
        }
        return responseMessage.getStatusCode();
    }

    public void setFwHeaderDefinition(FwHeaderDefinition fwHeaderDefinition) {
        this.fwHeaderDefinition = fwHeaderDefinition;
    }

    private void emitLog(InterSystemMessage<?> message, Charset charset) {
        String log = message instanceof ReceivedMessage ? MessagingLogUtil.getHttpReceivedMessageLog((ReceivedMessage)((ReceivedMessage)message), (Charset)charset) : MessagingLogUtil.getHttpSentMessageLog((SendingMessage)((SendingMessage)message), (Charset)charset);
        MESSAGING_LOGGER.logInfo(log, new Object[0]);
    }
}

