/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.realtime.http.client;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import nablarch.core.dataformat.InvalidDataFormatException;
import nablarch.core.dataformat.SimpleDataConvertResult;
import nablarch.core.dataformat.SimpleDataConvertUtil;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.MessageSenderClient;
import nablarch.fw.messaging.MessageSenderSettings;
import nablarch.fw.messaging.MessagingException;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.SendingMessage;
import nablarch.fw.messaging.SyncMessage;
import nablarch.fw.messaging.logging.MessagingLogUtil;
import nablarch.fw.messaging.realtime.http.client.HttpProtocolBasicClient;
import nablarch.fw.messaging.realtime.http.client.HttpProtocolClient;
import nablarch.fw.messaging.realtime.http.dto.HttpResult;
import nablarch.fw.messaging.realtime.http.exception.HttpMessagingInvalidDataFormatException;
import nablarch.fw.messaging.realtime.http.streamio.CharHttpStreamReader;
import nablarch.fw.messaging.realtime.http.streamio.CharHttpStreamWritter;
import nablarch.fw.messaging.realtime.http.streamio.HttpInputStreamReader;
import nablarch.fw.messaging.realtime.http.streamio.HttpOutputStreamWriter;

@Published(tag={"architect"})
public class HttpMessagingClient
implements MessageSenderClient {
    private static final Logger MESSAGING_LOGGER = LoggerManager.get((String)"MESSAGING");
    public static final String SYNCMESSAGE_STATUS_CODE = "STATUS_CODE";
    private static final String HTTP_HEADER_MESSAGE_ID = "X-Message-Id";
    private String responseMessageFormatFileNamePattern = "%s_RECEIVE";
    private String requestMessageFormatFileNamePattern = "%s_SEND";
    private String userIdToFormatKey = null;
    private static final List<String> EXIST_BODY_HTTP_METHOD = Arrays.asList("POST", "PUT");
    private String queryStringEncoding = "UTF-8";
    private static final Pattern CHARSET_PTN = Pattern.compile(".*charset=(.+)");

    public SyncMessage sendSync(MessageSenderSettings settings, SyncMessage requestMessage) throws MessagingException {
        HttpProtocolClient.HttpRequestMethodEnum httpMethod = null;
        try {
            httpMethod = HttpProtocolClient.HttpRequestMethodEnum.valueOf(settings.getHttpMethod().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new MessagingException(String.format("%s is unsupported HTTP method.", settings.getHttpMethod().toUpperCase()), (Throwable)e);
        }
        String preUri = settings.getUri();
        this.addCommonValue(httpMethod, settings, requestMessage);
        String uri = this.mapToUriString(preUri, httpMethod, requestMessage);
        Map<String, String> urlParams = this.mapToQueryMap(preUri, httpMethod, requestMessage);
        Map<String, List<String>> headerInfo = this.mapToHeaderMap(requestMessage);
        SimpleDataConvertResult bodyDataConvertResult = this.mapToBodyString(uri, httpMethod, requestMessage);
        String mimeType = this.getRequestContentsType(httpMethod, bodyDataConvertResult);
        HttpProtocolClient httpProtocolClient = this.createHttpProtocolClient();
        this.initHttpProtocolClient(httpProtocolClient, settings, mimeType);
        String charset = "UTF-8";
        String bodyText = "";
        if (bodyDataConvertResult != null) {
            charset = bodyDataConvertResult.getCharset().toString();
            bodyText = bodyDataConvertResult.getResultText();
        }
        if (MESSAGING_LOGGER.isInfoEnabled()) {
            this.emitRequestLog(requestMessage.getHeaderRecord(), httpMethod, uri, bodyText, charset);
        }
        HttpResult httpResult = this.execute(httpProtocolClient, httpMethod, uri, headerInfo, urlParams, charset, bodyText);
        SyncMessage responseMessage = new SyncMessage(requestMessage.getRequestId());
        Map<String, Object> resHeadderMap = this.headerToMap(requestMessage, httpResult);
        if (MESSAGING_LOGGER.isInfoEnabled()) {
            this.emitResponseLog(resHeadderMap, this.getResponseBody(httpResult), this.getResponseCharset(resHeadderMap));
        }
        SimpleDataConvertResult resBodyDataConvertResult = this.bodyStringToMap(uri, httpMethod, requestMessage, httpResult);
        responseMessage.setHeaderRecord(resHeadderMap);
        Map<String, ?> responseData = null;
        responseData = resBodyDataConvertResult != null ? resBodyDataConvertResult.getResultMap() : new TreeMap();
        responseMessage.addDataRecord(responseData);
        return responseMessage;
    }

    protected void addCommonValue(HttpProtocolClient.HttpRequestMethodEnum httpMethod, MessageSenderSettings settings, SyncMessage requestMessage) {
        String messageId;
        if (settings.getHttpMessageIdGenerator() != null && (messageId = settings.getHttpMessageIdGenerator().generateId()) != null) {
            requestMessage.getHeaderRecord().put(HTTP_HEADER_MESSAGE_ID, messageId);
        }
        if (this.getExistBodyHttpMethod().contains(httpMethod.toString())) {
            TreeMap<String, String> dataRecord = requestMessage.getDataRecord();
            if (dataRecord == null) {
                dataRecord = new TreeMap<String, String>();
                requestMessage.addDataRecord(dataRecord);
            }
            if (!(StringUtil.isNullOrEmpty((String)this.getUserIdToFormatKey()) || dataRecord.containsKey(this.getUserIdToFormatKey()) || StringUtil.isNullOrEmpty((String)settings.getHttpMessagingUserId()))) {
                dataRecord.put(this.getUserIdToFormatKey(), settings.getHttpMessagingUserId());
            }
        }
    }

    protected HttpProtocolClient createHttpProtocolClient() {
        return new HttpProtocolBasicClient();
    }

    protected void initHttpProtocolClient(HttpProtocolClient argHttpProtocolClient, MessageSenderSettings settings, String mimeType) {
        SSLContext sslContext;
        if (settings.getSslContextSettings() != null && (sslContext = settings.getSslContextSettings().getSSLContext()) != null) {
            argHttpProtocolClient.setSslContext(settings.getSslContextSettings().getSSLContext());
        }
        if (settings.getHttpProxyHost() != null) {
            argHttpProtocolClient.setProxyInfo(settings.getHttpProxyHost(), settings.getHttpProxyPort());
        }
        argHttpProtocolClient.setConnectTimeout(settings.getHttpConnectTimeout());
        argHttpProtocolClient.setReadTimeout(settings.getHttpReadTimeout());
        argHttpProtocolClient.setContentType(mimeType);
        argHttpProtocolClient.setAccept(this.getAccept());
        argHttpProtocolClient.setQueryStringEncoding(this.getQueryStringEncoding());
    }

    protected String getAccept() {
        return "text/json, text/xml";
    }

    protected String mapToUriString(String preUri, HttpProtocolClient.HttpRequestMethodEnum httpMethod, SyncMessage requestMessage) {
        return preUri;
    }

    protected Map<String, String> mapToQueryMap(String preUri, HttpProtocolClient.HttpRequestMethodEnum httpMethod, SyncMessage requestMessage) {
        return new HashMap<String, String>();
    }

    protected Map<String, List<String>> mapToHeaderMap(SyncMessage requestMessage) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (Map.Entry entry : requestMessage.getHeaderRecord().entrySet()) {
            ArrayList<String> value = new ArrayList<String>();
            if (entry.getValue() != null) {
                value.add(StringUtil.toString(entry.getValue()));
            } else {
                value.add("");
            }
            ret.put((String)entry.getKey(), (List<String>)value);
        }
        return ret;
    }

    protected SimpleDataConvertResult mapToBodyString(String uri, HttpProtocolClient.HttpRequestMethodEnum httpMethod, SyncMessage requestMessage) throws HttpMessagingInvalidDataFormatException {
        SimpleDataConvertResult ret = null;
        if (this.getExistBodyHttpMethod().contains(httpMethod.toString())) {
            Map dataRecord = requestMessage.getDataRecord();
            try {
                if (dataRecord.size() > 0) {
                    String formatName = String.format(this.getRequestMessageFormatFileNamePattern(), requestMessage.getRequestId());
                    ret = SimpleDataConvertUtil.buildData(formatName, dataRecord);
                }
            }
            catch (InvalidDataFormatException e) {
                String message = "Invalid request message format. requestId=[" + requestMessage.getRequestId() + "].";
                throw new HttpMessagingInvalidDataFormatException(message, uri, dataRecord, (Throwable)e);
            }
        }
        return ret;
    }

    protected String getRequestContentsType(HttpProtocolClient.HttpRequestMethodEnum httpMethod, SimpleDataConvertResult requestBodyDataConvertResult) {
        String contentType = "text/plain";
        Charset charset = Charset.forName("UTF-8");
        if (this.getExistBodyHttpMethod().contains(httpMethod.toString()) && requestBodyDataConvertResult != null) {
            contentType = requestBodyDataConvertResult.getMimeType();
            charset = requestBodyDataConvertResult.getCharset();
        }
        contentType = String.format("%s;charset=%s", contentType, charset.name());
        return contentType;
    }

    protected HttpResult execute(HttpProtocolClient httpProtocolClient, HttpProtocolClient.HttpRequestMethodEnum httpMethod, String uri, Map<String, List<String>> headerInfo, Map<String, String> urlParams, String charset, String bodyText) {
        HttpResult httpResult = null;
        HttpInputStreamReader reader = this.createCharHttpStreamReader();
        HttpOutputStreamWriter writer = null;
        switch (httpMethod) {
            case GET: {
                httpResult = httpProtocolClient.execute(httpMethod, uri, headerInfo, urlParams, null, reader);
                break;
            }
            case POST: {
                writer = this.createCharHttpStreamWritter(charset, bodyText);
                httpResult = httpProtocolClient.execute(httpMethod, uri, headerInfo, urlParams, writer, reader);
                break;
            }
            case PUT: {
                writer = this.createCharHttpStreamWritter(charset, bodyText);
                httpResult = httpProtocolClient.execute(httpMethod, uri, headerInfo, urlParams, writer, reader);
                break;
            }
            case DELETE: {
                httpResult = httpProtocolClient.execute(httpMethod, uri, headerInfo, urlParams, null, reader);
                break;
            }
        }
        return httpResult;
    }

    protected HttpInputStreamReader createCharHttpStreamReader() {
        return new CharHttpStreamReader();
    }

    protected HttpOutputStreamWriter createCharHttpStreamWritter(String charset, String bodyText) {
        CharHttpStreamWritter writer = new CharHttpStreamWritter(charset);
        writer.append(bodyText);
        return writer;
    }

    protected Map<String, Object> headerToMap(SyncMessage requestMessage, HttpResult httpResult) {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        Map<String, List<String>> headerInfo = httpResult.getHeaderInfo();
        for (Map.Entry<String, List<String>> entry : headerInfo.entrySet()) {
            String key = entry.getKey();
            if (key == null) {
                key = "";
            }
            List<String> values = entry.getValue();
            ret.put(key, values.get(0));
        }
        ret.put(SYNCMESSAGE_STATUS_CODE, Integer.toString(httpResult.getResponseCode()));
        return ret;
    }

    protected SimpleDataConvertResult bodyStringToMap(String uri, HttpProtocolClient.HttpRequestMethodEnum httpMethod, SyncMessage requestMessage, HttpResult httpResult) throws HttpMessagingInvalidDataFormatException {
        SimpleDataConvertResult ret = null;
        String data = (String)httpResult.getReadObject();
        try {
            if (!StringUtil.isNullOrEmpty((String)data)) {
                String formatName = String.format(this.getResponseMessageFormatFileNamePattern(), requestMessage.getRequestId());
                ret = SimpleDataConvertUtil.parseData(formatName, data);
            }
        }
        catch (InvalidDataFormatException e) {
            String message = "Invalid receive message format. requestId=[" + requestMessage.getRequestId() + "].";
            throw new HttpMessagingInvalidDataFormatException(message, uri, httpResult.getResponseCode(), httpResult.getHeaderInfo(), data, e);
        }
        return ret;
    }

    protected String getResponseMessageFormatFileNamePattern() {
        return this.responseMessageFormatFileNamePattern;
    }

    protected String getRequestMessageFormatFileNamePattern() {
        return this.requestMessageFormatFileNamePattern;
    }

    public String getUserIdToFormatKey() {
        return this.userIdToFormatKey;
    }

    public void setUserIdToFormatKey(String userIdToFormatKey) {
        this.userIdToFormatKey = userIdToFormatKey;
    }

    protected List<String> getExistBodyHttpMethod() {
        return EXIST_BODY_HTTP_METHOD;
    }

    public String getQueryStringEncoding() {
        return this.queryStringEncoding;
    }

    public void setQueryStringEncoding(String queryStringEncoding) {
        this.queryStringEncoding = queryStringEncoding;
    }

    private void emitRequestLog(Map<String, Object> requestHeader, HttpProtocolClient.HttpRequestMethodEnum method, String uri, final String bodyText, String charsetName) {
        final Charset charset = Charset.forName(charsetName);
        SendingMessage sendingMessage = new SendingMessage(){

            public byte[] getBodyBytes() {
                return bodyText.getBytes(charset);
            }
        };
        sendingMessage.setHeaderMap(requestHeader);
        sendingMessage.setDestination((Object)((Object)method) + " " + uri);
        String log = MessagingLogUtil.getHttpSentMessageLog((SendingMessage)sendingMessage, (Charset)charset);
        MESSAGING_LOGGER.logInfo(log, new Object[0]);
    }

    private void emitResponseLog(Map<String, Object> responseHeader, String bodyText, String charsetName) {
        Charset charset = Charset.forName(charsetName);
        byte[] bodyBytes = bodyText.getBytes(charset);
        ReceivedMessage receivedMessage = new ReceivedMessage(bodyBytes);
        receivedMessage.setHeaderMap(responseHeader);
        String log = MessagingLogUtil.getHttpReceivedMessageLog((ReceivedMessage)receivedMessage, (Charset)charset);
        MESSAGING_LOGGER.logInfo(log, new Object[0]);
    }

    private String getResponseBody(HttpResult httpResult) {
        return StringUtil.nullToEmpty((String)((String)httpResult.getReadObject()));
    }

    private String getResponseCharset(Map<String, Object> resHeadderMap) {
        Charset charset = Charset.defaultCharset();
        String contentTypeHeader = StringUtil.nullToEmpty((String)((String)resHeadderMap.get("Content-Type")));
        Matcher m = CHARSET_PTN.matcher(contentTypeHeader);
        if (m.find()) {
            charset = Charset.forName(m.group(1));
        }
        return charset.toString();
    }
}

