/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.realtime.http.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.MessagingException;
import nablarch.fw.messaging.realtime.http.client.HttpProtocolClient;
import nablarch.fw.messaging.realtime.http.dto.HttpResult;
import nablarch.fw.messaging.realtime.http.exception.HttpMessagingException;
import nablarch.fw.messaging.realtime.http.streamio.HttpInputStreamReader;
import nablarch.fw.messaging.realtime.http.streamio.HttpOutputStreamWriter;

@Published(tag={"architect"})
public class HttpProtocolBasicClient
implements HttpProtocolClient {
    private SSLContext sslContext;
    private int connectTimeout;
    private int readTimeout;
    private String proxyUrl;
    private int proxyPort;
    private String contentType;
    private String accept;
    private String queryStringEncoding = "UTF-8";

    @Override
    public void setProxyInfo(String url, int port) {
        this.proxyUrl = url;
        this.proxyPort = port;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setAccept(String accept) {
        this.accept = accept;
    }

    @Override
    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public void setQueryStringEncoding(String queryStringEncoding) {
        this.queryStringEncoding = queryStringEncoding;
    }

    /*
     * Exception decompiling
     */
    @Override
    public HttpResult execute(HttpProtocolClient.HttpRequestMethodEnum httpMethod, String url, Map<String, List<String>> headerInfo, Map<String, String> urlParams, HttpOutputStreamWriter writer, HttpInputStreamReader reader) throws HttpMessagingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected HttpURLConnection createHttpConnection(String targetUrl, HttpProtocolClient.HttpRequestMethodEnum method, Map<String, List<String>> headerInfo) throws IOException {
        HttpURLConnection con;
        URL url = new URL(targetUrl);
        if (this.proxyUrl != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyUrl, this.proxyPort));
            con = (HttpURLConnection)url.openConnection(proxy);
        } else {
            con = (HttpURLConnection)url.openConnection();
        }
        if (con instanceof HttpsURLConnection && this.sslContext != null) {
            ((HttpsURLConnection)con).setSSLSocketFactory(this.sslContext.getSocketFactory());
        }
        con.setConnectTimeout(this.connectTimeout);
        con.setReadTimeout(this.readTimeout);
        con.setRequestProperty("Content-type", this.contentType);
        con.setRequestProperty("Accept", this.accept);
        for (Map.Entry<String, List<String>> headerInfoEntrySet : headerInfo.entrySet()) {
            for (String value : headerInfoEntrySet.getValue()) {
                con.addRequestProperty(headerInfoEntrySet.getKey(), value);
            }
        }
        if (!method.equals((Object)HttpProtocolClient.HttpRequestMethodEnum.GET)) {
            con.setDoOutput(true);
        }
        con.setRequestMethod(method.toString());
        return con;
    }

    protected String paramStringBuilder(Map<String, String> paramData) {
        StringBuilder sbParam = new StringBuilder();
        for (Map.Entry<String, String> entry : paramData.entrySet()) {
            if (sbParam.length() != 0) {
                sbParam.append("&");
            }
            String value = null;
            try {
                value = URLEncoder.encode(entry.getValue(), this.queryStringEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException((Throwable)e);
            }
            sbParam.append(String.format("%s=%s", entry.getKey(), value));
        }
        return sbParam.toString();
    }
}

