/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.realtime.http.exception;

import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.MessagingException;

@Published
public class HttpMessagingException
extends MessagingException {
    private String targetUrl;
    private Integer statusCode;

    public HttpMessagingException() {
    }

    public HttpMessagingException(String message, Throwable cause) {
        super(message, cause);
    }

    public HttpMessagingException(String message) {
        super(message);
    }

    public HttpMessagingException(Throwable cause) {
        super(cause);
    }

    public HttpMessagingException(String targetUrl, Integer statusCode, Throwable cause) {
        super(cause);
        this.targetUrl = targetUrl;
        this.statusCode = statusCode;
    }

    public HttpMessagingException(String message, String targetUrl, Integer statusCode, Throwable cause) {
        super(message, cause);
        this.targetUrl = targetUrl;
        this.statusCode = statusCode;
    }

    public String getMessage() {
        boolean hasProp;
        String baseMsg = super.getMessage();
        boolean bl = hasProp = StringUtil.hasValue((String)this.targetUrl) || this.statusCode != null;
        if (baseMsg == null && !hasProp) {
            return baseMsg;
        }
        if (baseMsg == null) {
            baseMsg = "";
        }
        StringBuilder msg = new StringBuilder(baseMsg);
        if (StringUtil.hasValue((String)this.targetUrl)) {
            msg.append(" URL=[").append(this.targetUrl).append("].");
        }
        if (this.statusCode != null) {
            msg.append(" status code=[").append(this.statusCode.toString()).append("].");
        }
        return msg.toString();
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }
}

