/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging.realtime.http.streamio;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import nablarch.core.util.FileUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.realtime.http.streamio.HttpOutputStreamWriter;

@Published(tag={"architect"})
public abstract class AbstractCharHttpStreamWritter
implements HttpOutputStreamWriter {
    private String charset;

    public AbstractCharHttpStreamWritter() {
    }

    public AbstractCharHttpStreamWritter(String charset) {
        this.charset = charset;
    }

    @Override
    public void writeStream(OutputStream outputStream) throws IOException {
        BufferedWriter bw = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = this.getCharset() == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, this.getCharset());
            bw = new BufferedWriter(outputStreamWriter);
            for (int i = 0; i < this.getWriteTarget().size(); ++i) {
                bw.write(this.getWriteTarget().get(i));
                if (i >= this.getWriteTarget().size() - 1) continue;
                bw.write(this.getLineSeparator());
            }
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.closeQuietly((Closeable[])new Closeable[]{bw});
                throw throwable;
            }
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{bw});
    }

    public String getCharset() {
        return this.charset;
    }

    public String getLineSeparator() {
        return "";
    }

    public abstract List<String> getWriteTarget();
}

