/*
 * Decompiled with CFR 0.152.
 */
package nablarch.core.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import nablarch.core.util.ObjectUtil;
import nablarch.core.util.StringUtil;

public final class MapUtil {
    private MapUtil() {
    }

    public static Map<String, Object> createFlatMap(Object form) {
        return MapUtil.createFlatMap("", form);
    }

    public static Map<String, Object> createFlatMap(String prefix, Object form) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (form == null) {
            return map;
        }
        String innerPrefix = StringUtil.isNullOrEmpty((String)prefix) ? "" : prefix + ".";
        if (form instanceof Map) {
            for (Map.Entry e : ((Map)form).entrySet()) {
                if (e.getKey() == null) continue;
                if (e.getValue() instanceof Map) {
                    map.putAll(MapUtil.createFlatMap(innerPrefix + e.getKey(), e.getValue()));
                    continue;
                }
                map.put(innerPrefix + e.getKey(), e.getValue());
            }
            return map;
        }
        for (Method m : ObjectUtil.getGetterMethods(form.getClass())) {
            String propName = ObjectUtil.getPropertyNameFromGetter((Method)m);
            Object o = ObjectUtil.getProperty((Object)form, (String)propName);
            if (o == null) {
                map.put(innerPrefix + propName, null);
                continue;
            }
            if (o instanceof String) {
                map.put(innerPrefix + propName, o);
                continue;
            }
            if (o instanceof String[]) {
                map.put(innerPrefix + propName, o);
                continue;
            }
            if (o instanceof Number) {
                map.put(innerPrefix + propName, StringUtil.toString((Object)o));
                continue;
            }
            if (o instanceof Boolean) {
                map.put(innerPrefix + propName, o.toString());
                continue;
            }
            if (m.getReturnType().isArray()) {
                int length = Array.getLength(o);
                for (int i = 0; i < length; ++i) {
                    map.putAll(MapUtil.createFlatMap(innerPrefix + propName + "[" + i + "]", Array.get(o, i)));
                }
                continue;
            }
            map.putAll(MapUtil.createFlatMap(innerPrefix + propName, o));
        }
        return map;
    }
}

