/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.util.HashMap;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.MessagingException;

@Published(tag={"architect"})
public class FwHeader
extends HashMap<String, Object> {
    private static final String REQUEST_ID_KEY_NAME = "requestId";
    private static final String USER_KEY_NAME = "userId";
    private static final String RESEND_FLAG_KEY_NAME = "resendFlag";
    private static final String STATUS_CODE_KEY_NAME = "statusCode";
    private Object resendFlagOffValue = 0;

    public String getRequestId() {
        return (String)this.get(REQUEST_ID_KEY_NAME);
    }

    public FwHeader setRequestId(String requestId) {
        this.nullSafeSet(REQUEST_ID_KEY_NAME, requestId);
        return this;
    }

    public String getUserId() {
        return (String)this.get(USER_KEY_NAME);
    }

    public boolean hasUserId() {
        return this.containsKey(USER_KEY_NAME);
    }

    public FwHeader setUserId(String userId) {
        this.nullSafeSet(USER_KEY_NAME, userId);
        return this;
    }

    public boolean isResendingRequest() {
        Object flag = this.get(RESEND_FLAG_KEY_NAME);
        if (flag == null) {
            return false;
        }
        return !flag.toString().equals(this.resendFlagOffValue.toString());
    }

    public boolean isResendingSupported() {
        Object flag = this.get(RESEND_FLAG_KEY_NAME);
        return flag != null && flag.toString().length() != 0;
    }

    public FwHeader setResendFlag(Object flag) {
        this.put(RESEND_FLAG_KEY_NAME, flag);
        return this;
    }

    public String getStatusCode() {
        return (String)this.get(STATUS_CODE_KEY_NAME);
    }

    public FwHeader setStatusCode(String flag) {
        this.nullSafeSet(STATUS_CODE_KEY_NAME, flag);
        return this;
    }

    public FwHeader setResendFlagOffValue(Object offValue) {
        this.resendFlagOffValue = offValue;
        return this;
    }

    private void nullSafeSet(String key, Object value) {
        if (value == null || value instanceof String && value.toString().length() == 0) {
            throw new MessagingException("Could not read the fw header of " + key);
        }
        this.put(key, value);
    }
}

