/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nablarch.core.dataformat.DataRecord;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;

public abstract class InterSystemMessage<TSelf extends InterSystemMessage<?>> {
    private final Map<String, Object> headers;
    private final List<DataRecord> bodyData;
    private DataRecordFormatter formatter;

    public InterSystemMessage() {
        this.headers = new HashMap<String, Object>();
        this.bodyData = new ArrayList<DataRecord>();
        this.formatter = null;
    }

    public InterSystemMessage(InterSystemMessage<?> orgMessage) {
        this.headers = orgMessage.headers;
        this.bodyData = orgMessage.bodyData;
        this.formatter = orgMessage.formatter;
    }

    @Published(tag={"architect"})
    public TSelf setFormatter(DataRecordFormatter formatter) {
        this.formatter = formatter;
        return (TSelf)this;
    }

    public DataRecordFormatter getFormatter() {
        return this.formatter;
    }

    @Published(tag={"architect"})
    public DataRecord getRecordOf(String recordType) {
        for (DataRecord record : this.getRecords()) {
            if (!record.getRecordType().equals(recordType)) continue;
            return record;
        }
        return null;
    }

    @Published(tag={"architect"})
    public List<DataRecord> getRecords() {
        return this.bodyData;
    }

    @Published(tag={"architect"})
    public List<DataRecord> getRecordsOf(String recordType) {
        if (StringUtil.isNullOrEmpty((String)recordType)) {
            throw new IllegalArgumentException("recordType must not be blank.");
        }
        ArrayList<DataRecord> results = new ArrayList<DataRecord>();
        for (DataRecord record : this.getRecords()) {
            if (!record.getRecordType().equals(recordType)) continue;
            results.add(record);
        }
        return results;
    }

    @Published(tag={"architect"})
    public Map<String, Object> getParamMap() {
        return this.bodyData.size() == 0 ? null : this.bodyData.get(this.bodyData.size() - 1);
    }

    @Published(tag={"architect"})
    public Object getParam(String name) {
        Map<String, Object> record = this.getParamMap();
        return record == null ? null : record.get(name);
    }

    public abstract byte[] getBodyBytes();

    @Published(tag={"architect"})
    public Map<String, Object> getHeaderMap() {
        return this.headers;
    }

    public <T> T getHeader(String headerName) {
        return (T)this.headers.get(headerName);
    }

    public TSelf setHeader(String name, Object value) {
        this.headers.put(name, value);
        return (TSelf)this;
    }

    public TSelf setHeaderMap(Map<String, ?> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
        return (TSelf)this;
    }

    @Published(tag={"architect"})
    public String getMessageId() {
        return (String)this.getHeader("MessageId");
    }

    @Published(tag={"architect"})
    public TSelf setMessageId(String messageId) {
        if (StringUtil.isNullOrEmpty((String)messageId)) {
            throw new IllegalArgumentException("messageId must not be blank.");
        }
        this.setHeader("MessageId", messageId);
        return (TSelf)this;
    }

    @Published(tag={"architect"})
    public String getDestination() {
        return (String)this.getHeader("Destination");
    }

    @Published(tag={"architect"})
    public TSelf setDestination(String destination) {
        if (StringUtil.isNullOrEmpty((String)destination)) {
            throw new IllegalArgumentException("destination header must not be blank.");
        }
        this.setHeader("Destination", destination);
        return (TSelf)this;
    }

    @Published(tag={"architect"})
    public String getCorrelationId() {
        Object value = this.getHeader("CorrelationId");
        return value == null ? null : value.toString();
    }

    @Published(tag={"architect"})
    public TSelf setCorrelationId(String messageId) {
        if (StringUtil.isNullOrEmpty((String)messageId)) {
            throw new IllegalArgumentException("messageId must not be blank.");
        }
        this.setHeader("CorrelationId", messageId);
        return (TSelf)this;
    }

    @Published(tag={"architect"})
    public String getReplyTo() {
        return (String)this.getHeader("ReplyTo");
    }

    @Published(tag={"architect"})
    public TSelf setReplyTo(String replyTo) {
        if (StringUtil.isNullOrEmpty((String)replyTo)) {
            throw new IllegalArgumentException("replyTo header not be blank.");
        }
        this.setHeader("ReplyTo", replyTo);
        return (TSelf)this;
    }

    public static final class HeaderName {
        public static final String MESSAGE_ID = "MessageId";
        public static final String DESTINATION = "Destination";
        public static final String REPLY_TO = "ReplyTo";
        public static final String CORRELATION_ID = "CorrelationId";
        public static final String TIME_TO_LIVE = "TimeToLive";

        private HeaderName() {
        }
    }
}

