/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.FileUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.MessageSendSyncTimeoutException;
import nablarch.fw.messaging.MessageSenderClient;
import nablarch.fw.messaging.MessageSenderSettings;
import nablarch.fw.messaging.MessagingContext;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.SendingMessage;
import nablarch.fw.messaging.SyncMessage;
import nablarch.fw.messaging.SyncMessageConvertor;
import nablarch.fw.messaging.SyncMessagingEventHook;

@Published
public final class MessageSender {
    private static final Logger LOGGER = LoggerManager.get(MessageSender.class);
    private static final SyncMessageConvertor DEFAULT_MESSAGE_CONVERTOR = new SyncMessageConvertor();

    private MessageSender() {
    }

    public static SyncMessage sendSync(SyncMessage requestMessage) throws MessageSendSyncTimeoutException {
        MessageSenderSettings settings = new MessageSenderSettings(requestMessage.getRequestId());
        ArrayList<SyncMessagingEventHook> syncMessagingEventHookReverseList = new ArrayList<SyncMessagingEventHook>(settings.getSyncMessagingEventHookList());
        Collections.reverse(syncMessagingEventHookReverseList);
        for (SyncMessagingEventHook syncMessagingEventHook : settings.getSyncMessagingEventHookList()) {
            syncMessagingEventHook.beforeSend(settings, requestMessage);
        }
        SyncMessage responseMessage = null;
        try {
            responseMessage = settings.canUseMessageSenderClient() ? MessageSender.sendSyncWithMessageSenderClient(settings, requestMessage) : MessageSender.sendSyncWithProvider(settings, requestMessage);
        }
        catch (RuntimeException e) {
            if (syncMessagingEventHookReverseList.size() > 0) {
                responseMessage = new SyncMessage(requestMessage.getRequestId());
                for (int i = 0; i < syncMessagingEventHookReverseList.size(); ++i) {
                    SyncMessagingEventHook syncMessagingEventHook;
                    boolean hasNext = false;
                    if (i < syncMessagingEventHookReverseList.size() - 1) {
                        hasNext = true;
                    }
                    if ((syncMessagingEventHook = (SyncMessagingEventHook)syncMessagingEventHookReverseList.get(i)).onError(e, hasNext, settings, requestMessage, responseMessage)) continue;
                    throw e;
                }
                return responseMessage;
            }
            throw e;
        }
        for (SyncMessagingEventHook syncMessagingEventHook : syncMessagingEventHookReverseList) {
            syncMessagingEventHook.afterSend(settings, requestMessage, responseMessage);
        }
        return responseMessage;
    }

    private static SyncMessage sendSyncWithMessageSenderClient(MessageSenderSettings settings, SyncMessage requestMessage) {
        MessageSenderClient messagingClient = settings.getMessageSenderClient();
        return messagingClient.sendSync(settings, requestMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SyncMessage sendSyncWithProvider(MessageSenderSettings settings, SyncMessage requestMessage) {
        SendingMessage sendingMessage;
        SyncMessageConvertor messageConvertor = MessageSender.getSyncMessageConvertor(settings);
        MessagingContext context = settings.getMessagingProvider().createContext();
        SendingMessage timeoutSendingMessage = null;
        ReceivedMessage receivedMessage = null;
        try {
            int retryCount = 0;
            while ((receivedMessage = context.sendSync(sendingMessage = timeoutSendingMessage == null ? messageConvertor.convertOnSendSync(settings, requestMessage) : messageConvertor.convertOnRetry(settings, requestMessage, timeoutSendingMessage, retryCount), settings.getTimeout())) == null) {
                timeoutSendingMessage = sendingMessage;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTrace(String.format("timeout occurred while synchronous sending message. requestId = [%s], messageId = [%s], retryCount = [%s]", requestMessage.getRequestId(), timeoutSendingMessage.getMessageId(), retryCount), new Object[0]);
                }
                if (++retryCount <= settings.getRetryCount()) continue;
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly((Closeable[])new Closeable[]{context});
            throw throwable;
        }
        FileUtil.closeQuietly((Closeable[])new Closeable[]{context});
        if (receivedMessage == null) {
            throw new MessageSendSyncTimeoutException(String.format("caused by timeout, failed to send message. requestId = [%s], retryCount = [%s]", requestMessage.getRequestId(), settings.getRetryCount()), settings.getRetryCount());
        }
        return messageConvertor.convertOnReceiveSync(settings, requestMessage, sendingMessage, receivedMessage);
    }

    private static SyncMessageConvertor getSyncMessageConvertor(MessageSenderSettings settings) {
        SyncMessageConvertor messageConvertor = settings.getMessageConvertor();
        return messageConvertor == null ? DEFAULT_MESSAGE_CONVERTOR : messageConvertor;
    }
}

