/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.FormatterFactory;
import nablarch.core.repository.SystemRepository;
import nablarch.core.util.Builder;
import nablarch.core.util.FilePathSetting;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.HttpMessageIdGenerator;
import nablarch.fw.messaging.HttpSSLContextSettings;
import nablarch.fw.messaging.MessageSenderClient;
import nablarch.fw.messaging.MessagingProvider;
import nablarch.fw.messaging.SyncMessageConvertor;
import nablarch.fw.messaging.SyncMessagingEventHook;

@Published(tag={"architect"})
public class MessageSenderSettings {
    private static final String KEY_SEPARATOR = ".";
    private static final String KEY_PREFIX = "messageSender";
    private static final String KEY_DEFAULT_TARGET = "DEFAULT";
    private final String settingRequestId;
    private final String sendingRequestId;
    private MessagingProvider messagingProvider = null;
    private String destination = null;
    private String replyTo = "";
    private int retryCount = -1;
    private long timeout = -1L;
    private DataRecordFormatter headerFormatter = null;
    private DataRecordFormatter sendingDataFormatter = null;
    private DataRecordFormatter receivedDataFormatter = null;
    private SyncMessageConvertor messageConvertor = null;
    private final List<SyncMessagingEventHook> syncMessagingEventHookList;
    private final MessageSenderClient messageSenderClient;
    private String httpMessagingUserId = "";
    private int httpConnectTimeout = 0;
    private int httpReadTimeout = 0;
    private String uri = "";
    private String httpMethod = "";
    private HttpMessageIdGenerator httpMessageIdGenerator = null;
    private HttpSSLContextSettings sslContextSettings = null;
    private String httpProxyHost = null;
    private Integer httpProxyPort = null;

    public MessageSenderSettings(String requestId) {
        this.settingRequestId = requestId;
        SettingType settingType = SettingType.BOTH;
        boolean required = false;
        List insertionObjectList = this.getComponentList("syncMessagingEventHookNames", settingType, required);
        this.syncMessagingEventHookList = new ArrayList<SyncMessagingEventHook>();
        for (Object insertion : insertionObjectList) {
            if (insertion instanceof SyncMessagingEventHook) {
                this.syncMessagingEventHookList.add((SyncMessagingEventHook)insertion);
                continue;
            }
            String componentNames = this.getStringSetting("syncMessagingEventHookNames", settingType, required, null);
            throw new IllegalArgumentException(String.format("syncMessagingEventHookNames could not be converted to List<SyncMessagingEventHook> type. value = [%s], %s", componentNames, this.createSettingKeyMessage(settingType, "syncMessagingEventHookNames")));
        }
        settingType = SettingType.REQUEST_ID_ONLY;
        required = false;
        this.messageSenderClient = (MessageSenderClient)this.getComponent("messageSenderClient", settingType, required);
        if (this.canUseMessageSenderClient()) {
            settingType = SettingType.REQUEST_ID_ONLY;
            required = false;
            this.sendingRequestId = this.getStringSetting("sendingRequestId", settingType, required, requestId);
            settingType = SettingType.BOTH;
            required = false;
            this.httpMessagingUserId = this.getStringSetting("httpMessagingUserId", settingType, required, "");
            settingType = SettingType.REQUEST_ID_ONLY;
            required = true;
            this.uri = this.getStringSetting("uri", settingType, required, null);
            settingType = SettingType.BOTH;
            required = false;
            this.httpReadTimeout = this.getIntSetting("httpReadTimeout", settingType, required, 0);
            settingType = SettingType.BOTH;
            required = false;
            this.httpConnectTimeout = this.getIntSetting("httpConnectTimeout", settingType, required, 0);
            settingType = SettingType.BOTH;
            required = false;
            this.sslContextSettings = (HttpSSLContextSettings)this.getComponent("sslContextComponentName", settingType, required);
            settingType = SettingType.BOTH;
            required = false;
            this.httpProxyHost = this.getStringSetting("httpProxyHost", settingType, required, null);
            this.httpProxyPort = this.getIntSetting("httpProxyPort", settingType, required, null);
            settingType = SettingType.BOTH;
            required = true;
            this.httpMethod = this.getStringSetting("httpMethod", settingType, required, null);
            settingType = SettingType.BOTH;
            required = false;
            this.httpMessageIdGenerator = (HttpMessageIdGenerator)this.getComponent("httpMessageIdGeneratorComponentName", settingType, required);
        } else {
            settingType = SettingType.BOTH;
            required = true;
            this.messagingProvider = (MessagingProvider)this.getComponent("messagingProviderName", settingType, required);
            this.destination = this.getStringSetting("destination", settingType, required, null);
            this.replyTo = this.getStringSetting("replyTo", settingType, required, null);
            String headerFormatName = this.getStringSetting("headerFormatName", settingType, required, null);
            settingType = SettingType.BOTH;
            required = false;
            this.retryCount = this.getIntSetting("retryCount", settingType, required, -1);
            this.messageConvertor = (SyncMessageConvertor)this.getComponent("messageConvertorName", settingType, required);
            settingType = SettingType.REQUEST_ID_ONLY;
            required = false;
            this.timeout = this.getLongSetting("timeout", settingType, required, -1L);
            this.sendingRequestId = this.getStringSetting("sendingRequestId", settingType, required, requestId);
            settingType = SettingType.DEFAULT_ONLY;
            required = false;
            String formatDir = this.getStringSetting("formatDir", settingType, required, "format");
            try {
                FilePathSetting.getInstance().getBaseDirectory(formatDir);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("formatDir was not found. formatDir = [%s], %s", formatDir, this.createSettingKeyMessage(SettingType.DEFAULT_ONLY, "formatDir")), e);
            }
            this.headerFormatter = this.getFormatter("headerFormatName", settingType, formatDir, headerFormatName);
            this.sendingDataFormatter = this.getFormatter(null, null, formatDir, requestId + "_SEND");
            this.receivedDataFormatter = this.getFormatter(null, null, formatDir, requestId + "_RECEIVE");
        }
    }

    public boolean canUseMessageSenderClient() {
        return this.messageSenderClient != null;
    }

    public <T> T getComponent(String propertyName, SettingType settingType, boolean required) {
        String componentName = this.getStringSetting(propertyName, settingType, required, null);
        if (componentName == null && !required) {
            return null;
        }
        Object component = SystemRepository.get((String)componentName);
        if (component == null) {
            throw new IllegalArgumentException(String.format("component was not found. componentName = [%s], %s", componentName, this.createSettingKeyMessage(settingType, propertyName)));
        }
        return (T)component;
    }

    public <T> List<T> getComponentList(String propertyName, SettingType settingType, boolean required) {
        ArrayList<Object> componentList = new ArrayList<Object>();
        String componentNames = this.getStringSetting(propertyName, settingType, required, null);
        if (componentNames != null) {
            String[] componentNameArray;
            for (String componentName : componentNameArray = componentNames.split(",")) {
                Object t = SystemRepository.get((String)componentName.trim());
                if (t == null) {
                    throw new IllegalArgumentException(String.format("component was not found. componentName = [%s], %s", componentName.trim(), this.createSettingKeyMessage(settingType, propertyName)));
                }
                componentList.add(SystemRepository.get((String)componentName.trim()));
            }
        }
        return componentList;
    }

    public DataRecordFormatter getFormatter(String propertyName, SettingType settingType, String formatDir, String formatName) {
        File formatFile = FilePathSetting.getInstance().getFileWithoutCreate(formatDir, formatName);
        try {
            return FormatterFactory.getInstance().createFormatter(formatFile);
        }
        catch (RuntimeException e) {
            String message = "failed to parse format file. requestId = [" + this.settingRequestId + ']';
            if (propertyName != null) {
                message = message + ", " + this.createSettingKeyMessage(settingType, propertyName);
            }
            throw new IllegalArgumentException(message, e);
        }
    }

    public String getSettingRequestId() {
        return this.settingRequestId;
    }

    public String getSendingRequestId() {
        return this.sendingRequestId;
    }

    public MessagingProvider getMessagingProvider() {
        return this.messagingProvider;
    }

    public SyncMessageConvertor getMessageConvertor() {
        return this.messageConvertor;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public DataRecordFormatter getHeaderFormatter() {
        return this.headerFormatter;
    }

    public DataRecordFormatter getSendingDataFormatter() {
        return this.sendingDataFormatter;
    }

    public DataRecordFormatter getReceivedDataFormatter() {
        return this.receivedDataFormatter;
    }

    public List<SyncMessagingEventHook> getSyncMessagingEventHookList() {
        return this.syncMessagingEventHookList;
    }

    public MessageSenderClient getMessageSenderClient() {
        return this.messageSenderClient;
    }

    public String getHttpMessagingUserId() {
        return this.httpMessagingUserId;
    }

    public int getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public HttpMessageIdGenerator getHttpMessageIdGenerator() {
        return this.httpMessageIdGenerator;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpSSLContextSettings getSslContextSettings() {
        return this.sslContextSettings;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    private String createSettingKey(String targetName, String propertyName) {
        return Builder.join((Object[])new Object[]{KEY_PREFIX, targetName, propertyName}, (String)KEY_SEPARATOR);
    }

    public Integer getIntSetting(String propertyName, SettingType settingType, boolean required, Integer defaultValue) {
        String string = this.getStringSetting(propertyName, settingType, required, null);
        if (StringUtil.isNullOrEmpty((String)string)) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to Integer type. value = [%s], %s", propertyName, string, this.createSettingKeyMessage(settingType, propertyName)), e);
        }
    }

    public Long getLongSetting(String propertyName, SettingType settingType, boolean required, Long defaultValue) {
        String string = this.getStringSetting(propertyName, settingType, required, null);
        if (StringUtil.isNullOrEmpty((String)string)) {
            return defaultValue;
        }
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("%s could not be converted to Long type. value = [%s], %s", propertyName, string, this.createSettingKeyMessage(settingType, propertyName)), e);
        }
    }

    public String getStringSetting(String propertyName, SettingType settingType, boolean required, String defaultValue) {
        String value = null;
        String key = null;
        if (SettingType.REQUEST_ID_ONLY == settingType || SettingType.BOTH == settingType) {
            key = this.createSettingKey(this.settingRequestId, propertyName);
            value = SystemRepository.getString((String)key);
        }
        String defaultKey = null;
        if (StringUtil.isNullOrEmpty(value) && (SettingType.DEFAULT_ONLY == settingType || SettingType.BOTH == settingType)) {
            defaultKey = this.createSettingKey(KEY_DEFAULT_TARGET, propertyName);
            value = SystemRepository.getString((String)defaultKey);
        }
        if (StringUtil.isNullOrEmpty((String)value)) {
            if (required) {
                throw new IllegalArgumentException(String.format("%s was not specified. %s", propertyName, this.createSettingKeyMessage(settingType, propertyName)));
            }
            value = defaultValue;
        }
        return value;
    }

    public String createSettingKeyMessage(SettingType settingType, String propertyName) {
        switch (settingType) {
            case DEFAULT_ONLY: {
                return String.format("defaultKey = [%s]", this.createSettingKey(KEY_DEFAULT_TARGET, propertyName));
            }
            case REQUEST_ID_ONLY: {
                return String.format("key = [%s]", this.createSettingKey(this.settingRequestId, propertyName));
            }
        }
        return String.format("defaultKey = [%s] or key = [%s]", this.createSettingKey(KEY_DEFAULT_TARGET, propertyName), this.createSettingKey(this.settingRequestId, propertyName));
    }

    public static enum SettingType {
        DEFAULT_ONLY,
        REQUEST_ID_ONLY,
        BOTH;

    }
}

