/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.io.Closeable;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.FileUtil;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.InterSystemMessage;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.SendingMessage;
import nablarch.fw.messaging.logging.MessagingLogUtil;

@Published(tag={"architect"})
public abstract class MessagingContext
implements Closeable {
    private static final ThreadLocal<MessagingContext> CONTEXT_FOR_EACH_THREAD = new ThreadLocal();
    private static final Logger LOGGER = LoggerManager.get((String)"MESSAGING");

    public static MessagingContext getInstance() throws IllegalStateException {
        MessagingContext ctx = CONTEXT_FOR_EACH_THREAD.get();
        if (ctx == null) {
            throw new IllegalStateException("there is no messaging context on the current thread.");
        }
        return ctx;
    }

    public static void attach(MessagingContext context) {
        CONTEXT_FOR_EACH_THREAD.set(context);
    }

    public static void detach() {
        MessagingContext context = CONTEXT_FOR_EACH_THREAD.get();
        if (context != null) {
            FileUtil.closeQuietly((Closeable[])new Closeable[]{context});
            CONTEXT_FOR_EACH_THREAD.remove();
        }
    }

    public String send(SendingMessage message) {
        String messageId = this.sendMessage(message);
        if (LOGGER.isInfoEnabled()) {
            this.emitLog(message);
        }
        return messageId;
    }

    public ReceivedMessage sendSync(SendingMessage message) {
        return this.sendSync(message, 0L);
    }

    public ReceivedMessage sendSync(SendingMessage message, long timeout) {
        String replyQueueName = message.getReplyTo();
        if (StringUtil.isNullOrEmpty((String)replyQueueName)) {
            throw new IllegalArgumentException("replyTo header must be set.");
        }
        if (0L < timeout) {
            message.setHeader("TimeToLive", timeout);
        }
        String messageId = this.send(message);
        Thread.yield();
        ReceivedMessage reply = this.receiveSync(replyQueueName, messageId, timeout);
        if (reply == null && LOGGER.isInfoEnabled()) {
            LOGGER.logInfo("response timeout: could not receive a reply to the message below." + MessagingLogUtil.getSentMessageLog(message), new Object[0]);
        }
        return reply;
    }

    public ReceivedMessage receiveSync(String receiveQueue) {
        return this.receiveSync(receiveQueue, null, 0L);
    }

    public ReceivedMessage receiveSync(String receiveQueue, long timeout) {
        return this.receiveSync(receiveQueue, null, timeout);
    }

    public ReceivedMessage receiveSync(String receiveQueue, String messageId, long timeout) {
        ReceivedMessage received = this.receiveMessage(receiveQueue, messageId, timeout);
        if (received == null) {
            return null;
        }
        if (LOGGER.isInfoEnabled()) {
            this.emitLog(received);
        }
        return received;
    }

    public abstract String sendMessage(SendingMessage var1);

    public abstract ReceivedMessage receiveMessage(String var1, String var2, long var3);

    @Override
    public abstract void close();

    protected void emitLog(InterSystemMessage<?> message) {
        String log = message instanceof ReceivedMessage ? MessagingLogUtil.getReceivedMessageLog((ReceivedMessage)message) : MessagingLogUtil.getSentMessageLog((SendingMessage)message);
        LOGGER.logInfo(log, new Object[0]);
    }
}

