/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import nablarch.core.dataformat.DataRecord;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.InterSystemMessage;
import nablarch.fw.messaging.MessagingException;

@Published(tag={"architect"})
public class ReceivedMessage
extends InterSystemMessage<ReceivedMessage> {
    private final ByteArrayInputStream bodyStream;
    private final byte[] bodyBytes;

    public ReceivedMessage(byte[] bodyBytes) {
        this.bodyBytes = bodyBytes;
        this.bodyStream = new ByteArrayInputStream(bodyBytes);
    }

    public ReceivedMessage(ReceivedMessage orgMessage) {
        super(orgMessage);
        this.bodyStream = orgMessage.bodyStream;
        this.bodyBytes = orgMessage.bodyBytes;
    }

    @Override
    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    @Published(tag={"architect"})
    public DataRecord readRecord() {
        DataRecordFormatter formatter = this.getFormatter();
        if (formatter == null) {
            throw new IllegalStateException("could not read record because any formatter was not set.");
        }
        try {
            DataRecord result = formatter.setInputStream((InputStream)this.bodyStream).initialize().readRecord();
            if (result != null) {
                this.getRecords().add(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new MessagingException(e);
        }
    }

    @Published(tag={"architect"})
    public List<DataRecord> readRecords() {
        DataRecordFormatter formatter = this.getFormatter();
        if (formatter == null) {
            throw new IllegalStateException("could not read record because any formatter was not set.");
        }
        try {
            ArrayList<DataRecord> result = new ArrayList<DataRecord>();
            DataRecord currRecord = null;
            while ((currRecord = formatter.setInputStream((InputStream)this.bodyStream).initialize().readRecord()) != null) {
                result.add(currRecord);
            }
            this.getRecords().addAll(result);
            return result;
        }
        catch (IOException e) {
            throw new MessagingException(e);
        }
    }
}

