/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.util.StringUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.Request;
import nablarch.fw.messaging.FwHeader;
import nablarch.fw.messaging.MessagingException;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.ResponseMessage;

@Published
public class RequestMessage
extends ReceivedMessage
implements Request<Object> {
    private final FwHeader fwHeader;
    private DataRecordFormatter formatterOfReply;

    public RequestMessage(FwHeader header, ReceivedMessage message) {
        super(message);
        this.fwHeader = header;
    }

    public ResponseMessage reply() throws UnsupportedOperationException {
        if (this.getReplyTo() == null) {
            throw new MessagingException("can not reply to this message because there was no 'replyTo' header on it.");
        }
        ResponseMessage response = this.createResponseMessage();
        response.setFormatter(this.formatterOfReply == null ? this.getFormatter() : this.formatterOfReply);
        return response;
    }

    protected ResponseMessage createResponseMessage() {
        return new ResponseMessage(this);
    }

    public String getRequestPath() {
        return this.fwHeader.getRequestId();
    }

    public RequestMessage setRequestPath(String requestPath) {
        if (StringUtil.isNullOrEmpty((String)requestPath)) {
            throw new IllegalArgumentException("requestPath must not be blank.");
        }
        this.fwHeader.setRequestId(requestPath);
        return this;
    }

    public FwHeader getFwHeader() {
        return this.fwHeader;
    }

    public RequestMessage setFormatterOfReply(DataRecordFormatter formatter) {
        this.formatterOfReply = formatter;
        return this;
    }
}

