/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.util.Map;
import nablarch.core.util.annotation.Published;
import nablarch.fw.Result;
import nablarch.fw.messaging.ErrorResponseMessage;
import nablarch.fw.messaging.FwHeader;
import nablarch.fw.messaging.FwHeaderDefinition;
import nablarch.fw.messaging.ReceivedMessage;
import nablarch.fw.messaging.RequestMessage;
import nablarch.fw.messaging.SendingMessage;

public class ResponseMessage
extends SendingMessage
implements Result {
    private final FwHeader fwHeader;
    private FwHeaderDefinition fwHeaderDefinition;
    private Result result = new Result.Success();
    private boolean wroteHeader = false;

    public ResponseMessage(FwHeader fwHeader, ReceivedMessage message) {
        this.setDestination(message.getReplyTo());
        this.setCorrelationId(message.getMessageId());
        this.setFormatter(message.getFormatter());
        this.fwHeader = fwHeader;
        this.setResult((Result)new Result.Success());
    }

    @Published(tag={"architect"})
    public ResponseMessage(RequestMessage message) {
        this.setDestination(message.getReplyTo());
        this.setCorrelationId(message.getMessageId());
        this.setFormatter(message.getFormatter());
        this.fwHeader = message.getFwHeader();
        this.setResult((Result)new Result.Success());
    }

    @Override
    public byte[] getBodyBytes() {
        if (this.fwHeaderDefinition == null) {
            throw new IllegalStateException("Could not serialize fwHeader because fwHeaderDefinition was not assigned to this response.");
        }
        if (!this.wroteHeader) {
            this.wroteHeader = true;
            this.fwHeaderDefinition.writeFwHeaderTo(this, this.fwHeader);
        }
        return super.getBodyBytes();
    }

    public void throwAsError(Throwable e) {
        throw new ErrorResponseMessage(this, e);
    }

    public void throwAsError() {
        throw new ErrorResponseMessage(this);
    }

    public int getStatusCode() {
        return this.result.getStatusCode();
    }

    public String getMessage() {
        return this.result.getMessage();
    }

    public boolean isSuccess() {
        return this.result.isSuccess();
    }

    public ResponseMessage setResult(Result result) {
        this.result = result;
        return this;
    }

    public FwHeader getFwHeader() {
        return this.fwHeader;
    }

    @Published(tag={"architect"})
    public ResponseMessage setFwHeaderDefinition(FwHeaderDefinition def) {
        this.fwHeaderDefinition = def;
        return this;
    }

    @Published(tag={"architect"})
    public ResponseMessage setStatusCodeHeader(String statusCode) {
        this.fwHeader.setStatusCode(statusCode);
        return this;
    }

    @Override
    @Published(tag={"architect"})
    public ResponseMessage addRecord(Map<String, ?> record) {
        super.addRecord(record);
        return this;
    }

    @Override
    @Published(tag={"architect"})
    public ResponseMessage addRecord(String recordType, Map<String, ?> record) {
        super.addRecord(recordType, record);
        return this;
    }

    @Override
    @Published(tag={"architect"})
    public ResponseMessage addRecord(Object recordObj) {
        super.addRecord(recordObj);
        return this;
    }

    @Override
    @Published(tag={"architect"})
    public ResponseMessage addRecord(String recordType, Object recordObj) {
        super.addRecord(recordType, recordObj);
        return this;
    }
}

