/*
 * Decompiled with CFR 0.152.
 */
package nablarch.fw.messaging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import nablarch.core.dataformat.DataRecord;
import nablarch.core.dataformat.DataRecordFormatter;
import nablarch.core.dataformat.InvalidDataFormatException;
import nablarch.core.util.MapUtil;
import nablarch.core.util.annotation.Published;
import nablarch.fw.messaging.InterSystemMessage;

public class SendingMessage
extends InterSystemMessage<SendingMessage> {
    private final ByteArrayOutputStream bodyStream = new ByteArrayOutputStream(4096);

    @Published(tag={"architect"})
    public SendingMessage() {
    }

    public SendingMessage(SendingMessage original) {
        super(original);
    }

    @Published
    public SendingMessage addRecord(Map<String, ?> record) throws InvalidDataFormatException {
        return this.addRecord(null, record);
    }

    @Published
    public SendingMessage addRecord(String recordType, Map<String, ?> record) throws InvalidDataFormatException {
        DataRecord typedRecord = new DataRecord().setRecordType(recordType);
        typedRecord.putAll(record);
        DataRecordFormatter formatter = this.getFormatter().setOutputStream((OutputStream)this.bodyStream).initialize();
        try {
            if (recordType == null) {
                formatter.writeRecord((Map)typedRecord);
            } else {
                formatter.writeRecord(recordType, (Map)typedRecord);
            }
            this.getRecords().add(typedRecord);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Published
    public SendingMessage addRecord(Object recordObj) throws InvalidDataFormatException {
        return this.addRecord(null, recordObj);
    }

    @Published
    public SendingMessage addRecord(String recordType, Object recordObj) throws InvalidDataFormatException {
        Map<String, Object> record = MapUtil.createFlatMap(recordObj);
        return this.addRecord(recordType, record);
    }

    @Override
    @Published(tag={"architect"})
    public byte[] getBodyBytes() {
        return this.bodyStream.toByteArray();
    }

    @Published(tag={"architect"})
    public ByteArrayOutputStream getBodyStream() {
        return this.bodyStream;
    }

    public long getTimeToLive() {
        Long value = (Long)this.getHeader("TimeToLive");
        return value == null ? 0L : (value <= 0L ? 0L : value);
    }

    @Published(tag={"architect"})
    public SendingMessage setTimeToLive(long timeToLive) {
        timeToLive = timeToLive < 0L ? 0L : timeToLive;
        this.setHeader("TimeToLive", timeToLive);
        return this;
    }
}

